% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_inference.R
\name{compute_t_values}
\alias{compute_t_values}
\title{Compute t-values for regression coefficients}
\usage{
compute_t_values(beta_hat, Y_fuzzy, Y_pred, XtX_inv)
}
\arguments{
\item{beta_hat}{Numeric vector. Estimated regression coefficients.}

\item{Y_fuzzy}{List. Observed fuzzy responses.}

\item{Y_pred}{List. Predicted fuzzy responses.}

\item{XtX_inv}{Matrix. Inverse of the XtX matrix.}
}
\value{
Numeric vector of t-values for the regression coefficients.
}
\description{
Compute t-values for regression coefficients
}
\examples{
# Example setup
beta_hat <- c(0.5, 1.2)  # Example regression coefficients
Y_fuzzy <- list(
  list(l = 2.1, x = 2.3, r = 2.5),
  list(l = 3.1, x = 3.3, r = 3.5),
  list(l = 4.1, x = 4.3, r = 4.5)
)  # Example fuzzy response
Y_pred <- list(
  list(l = 2.0, x = 2.2, r = 2.4),
  list(l = 3.0, x = 3.2, r = 3.4),
  list(l = 4.0, x = 4.2, r = 4.4)
)  # Example predicted values
XtX_inv <- matrix(c(0.1, 0.2, 0.2, 0.4), ncol = 2)  # Example XtX_inv matrix
t_values <- compute_t_values(beta_hat, Y_fuzzy, Y_pred, XtX_inv)
print(t_values)
}
