% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flassomsm.R
\name{flassomsm}
\alias{flassomsm}
\title{flassomsm}
\usage{
flassomsm(
  msdata,
  X,
  p,
  lambda_lasso,
  lambda_fused,
  tol_outer = 1e-04,
  max_outer = 50,
  rho = 1,
  tol_admm = 1e-04,
  max_admm = 100,
  trace = TRUE,
  MSM_profile = FALSE,
  use_parallel = TRUE
)
}
\arguments{
\item{msdata}{is a multi-state model in extended form having columns Tstart,Tstop,trans (covariates expanded transition wise)}

\item{X}{expanded covariate matrix of the msdata}

\item{p}{number of covariates in the dataset before expanding}

\item{lambda_lasso}{parameter for lasso penalty}

\item{lambda_fused}{parameter for fused penalty}

\item{tol_outer}{tolerence limit in the outer loop of PIRLS algorithm to converge}

\item{max_outer}{round of iterations until tolerence is reached for the outer loop}

\item{rho}{augmented Lagrangian parameter}

\item{tol_admm}{tolerence limit in the inner loop of ADMM algorithm to converge}

\item{max_admm}{round of iterations until tolerence is reached for the inner loop}

\item{trace}{logical triggering for status information}

\item{MSM_profile}{logical triggering to return the results}

\item{use_parallel}{logical flag to indicate whether to use parallel processing}
}
\value{
A list with elements like matrix of estimated beta coefficients along with standard error and p value,number of iterations, aic (Akaike Information Criterion) value, gcv (GCV criterion) value and df (degrees of freedom)
}
\description{
Fits a penalized regression model with combined Fusedlasso penalty using hybrid algorithm
}
\details{
This is the core function of the package.This function fits a penalized Cox-type regression model
within the framework of a multi-state model. It is designed to handle transition-specific covariate effects
across multiple states by incorporating a regularization approach that combines both the Lasso penalty and
the Fused penalty. The penalization is of the L1 type, meaning it applies to the absolute values of
the regression coefficients, encouraging sparsity in the model. Additionally, it penalizes the absolute
differences between corresponding coefficients across different transitions, promoting similarity or grouping
of effects across transitions when appropriate. This dual-penalty structure enables both variable selection and
smoothing of covariate effects across related transitions, which is particularly useful in complex multi-state
settings where covariate effects may share underlying patterns but still exhibit transition-specific behaviors.
The parameters are estimated using a hybrid algorithm techinique combining PIRLS and ADMM together.
}
\examples{
##
set.seed(123)
data(msdata_3state)
covs1 <- msdata_3state[,9:10]
flassomsm(msdata = msdata_3state,X=msdata_3state[,c(11:dim(msdata_3state)[[2]])],
p = length(covs1),lambda_lasso = 0.3,lambda_fused = 0.5,tol_outer = 1e-4,
max_outer = 50, rho = 1, tol_admm = 1e-4, max_admm = 100,trace = TRUE,
MSM_profile = FALSE)

# For 2 covariates and 3 number of transitions

\donttest{
# Simulate msdata_4state instead of loading from disk
msdata_4state <- simdata(seed=123,n=1000,dist="weibull",cdist="exponential",
                 cparams=list(rate = 0.1),lambdas=c(0.1, 0.2, 0.3, 0.4),
                 gammas=c(1.5, 2, 2.5, 2.6),beta_list=list(c(-0.05, 0.01, 0.5, 0.6),
                 c(-0.03, 0.02, 0.07, 0.08),c(-0.04, 0.03, 0.04, -0.03),
                 c(-0.05,0.05,0.6,0.8)),cov_means=c(0,10,2,3),cov_sds=c(1,20,5,1.05),
                 trans_list=list(c(2, 3, 4, 5),c(3, 4, 5),c(4, 5), c(5), c()),
                 state_names=c("Tx", "Rec", "Death", "Reldeath", "srv"))

set.seed(123)
sub_msdata_4state <- msdata_4state[msdata_4state$id \%in\% sample(unique(msdata_4state$id), 10), ]
covs1 <- sub_msdata_4state[,9:10]
flassomsm(msdata = sub_msdata_4state,X=sub_msdata_4state[,c(13:32)],
         p = length(covs1),lambda_lasso = 0.5,lambda_fused = 0.6,tol_outer = 1e-4,
         max_outer = 50, rho = 1, tol_admm = 1e-4, max_admm = 100,trace = TRUE,MSM_profile = FALSE)
}
# For 2 covariates and 10 number of transitions
##
}
\author{
Atanu Bhattacharjee,Gajendra Kumar Vishwakarma,Abhipsa Tripathy
}
