% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_conv_crit_fns.R
\name{flash_conv_crit_max_chg}
\alias{flash_conv_crit_max_chg}
\title{Calculate the maximum absolute difference in scaled loadings and factors}
\usage{
flash_conv_crit_max_chg(curr, prev, k)
}
\arguments{
\item{curr}{The \code{\link{flash_fit}} object from the current iteration.}

\item{prev}{The \code{\link{flash_fit}} object from the previous iteration.}

\item{k}{Only used during sequential backfits (that is, calls to
\code{\link{flash_backfit}} where \code{extrapolate = FALSE}). It then
takes the index of the factor/loadings pair currently being optimized.}
}
\value{
A scalar, which is compared against the tolerance parameter
  \code{tol} to determine whether a fit has converged.
}
\description{
An alternative objective function that can be used to determine
  convergence when fitting a \code{\link{flash}} object. Calculates the
  maximum (absolute) change over all (posterior expected values for)
  loadings \eqn{\ell_{ik}} and factors \eqn{f_{jk}}. At each iteration, the
  loadings vectors \eqn{\ell_{\cdot 1}, \ldots, \ell_{\cdot K}} and factors
  \eqn{f_{\cdot 1}, \ldots, f_{\cdot K}} are \eqn{L^2}-normalized.
}
\seealso{
\code{\link{flash_conv_crit_elbo_diff}},
  \code{\link{flash_conv_crit_max_chg_L}}
  \code{\link{flash_conv_crit_max_chg_F}}
}
