% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Psurveys}
\alias{Psurveys}
\title{Number of Groups of Glass Data}
\format{
A \code{list} with nine objects of class \code{psData}---see
  \code{\link{readData}} for more details. The elements of the list are
  named: \code{coulson}, \code{jackson}, \code{lau}, \code{lewis.all},
  \code{lewis.clothing}, \code{lewis.shoes}, \code{pettard},
  \code{ross}, and \code{roux}, corresponding to the lead author in each of
  the references given below. \code{lau}, \code{pettard}, and \code{ross}
  were taken from Coulson et al. (2001) rather than the original source. The three
  objects starting with \code{lewis} represent the combined data (\code{all}),
  the groups of glass found on the outer clothing (\code{clothing}), and the groups of
  glass found on shoes/footwear (\code{shoes}).
}
\source{
Coulson, S. A., Buckleton, J. S., Gummer, A. B., and Triggs, C. M.
(2001) \doi{10.1016/S1355-0306(01)71847-3} Glass on clothing and shoes of members
 of the general population and people suspected of breaking crimes, Science &
 Justice, 41(1):39--48.
}
\usage{
data(Psurveys)
}
\description{
Count data from six different surveys looking at the number of sources/groups
of glass found on the upper surfaces of clothing taken from the general public.
}
\references{
\insertRef{lau1997}{fitPS}

\insertRef{lewis2023}{fitPS}

\insertRef{petterd1998}{fitPS}

\insertRef{ross1998}{fitPS}

\insertRef{roux2001}{fitPS}

\insertRef{jackson2013}{fitPS}
}
\keyword{datasets}
