% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guard_basic.R
\name{GuardBasic}
\alias{GuardBasic}
\title{R6 class for the Basic authentication guard}
\description{
This class encapsulates the logic of the
\href{https://datatracker.ietf.org/doc/html/rfc7617}{Basic authentication scheme}.
See \code{\link[=guard_basic]{guard_basic()}} for more information.
}
\examples{
# Create a guard of dubious quality
basic <- GuardBasic$new(
  validate = function(user, password) {
    user == "thomas" && password == "pedersen"
  },
  user_info = function(user) {
    new_user_info(
      name_given = "Thomas",
      name_middle = "Lin",
      name_family = "Pedersen"
    )
  }
)

}
\section{Super class}{
\code{\link[fireproof:Guard]{fireproof::Guard}} -> \code{GuardBasic}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{open_api}}{An OpenID compliant security scheme description}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GuardBasic-new}{\code{GuardBasic$new()}}
\item \href{#method-GuardBasic-check_request}{\code{GuardBasic$check_request()}}
\item \href{#method-GuardBasic-reject_response}{\code{GuardBasic$reject_response()}}
\item \href{#method-GuardBasic-clone}{\code{GuardBasic$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="Guard" data-id="forbid_user"><a href='../../fireproof/html/Guard.html#method-Guard-forbid_user'><code>fireproof::Guard$forbid_user()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fireproof" data-topic="Guard" data-id="register_handler"><a href='../../fireproof/html/Guard.html#method-Guard-register_handler'><code>fireproof::Guard$register_handler()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardBasic-new"></a>}}
\if{latex}{\out{\hypertarget{method-GuardBasic-new}{}}}
\subsection{Method \code{new()}}{
Constructor for the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardBasic$new(validate, user_info = NULL, realm = "private", name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{validate}}{A function that will be called with the arguments
\code{username}, \code{password}, \code{realm}, \code{request}, and \code{response} and returns \code{TRUE}
if the user is valid, and \code{FALSE} otherwise. If the function returns a
character vector it is considered to be authenticated and the return value
will be understood as scopes the user is granted.}

\item{\code{user_info}}{A function to extract user information from the
username. It is called with a single argument: \code{user} which is the username
used for the successful authentication. The function should return a new
\link[=new_user_info]{user_info} list.}

\item{\code{realm}}{The realm this authentication corresponds to. Will be returned
to the client on a failed authentication attempt to inform them of the
credentials required, though most often these days it is kept from the user.}

\item{\code{name}}{The name of the authentication}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardBasic-check_request"></a>}}
\if{latex}{\out{\hypertarget{method-GuardBasic-check_request}{}}}
\subsection{Method \code{check_request()}}{
A function that validates an incoming request, returning
\code{TRUE} if it is valid and \code{FALSE} if not. It decodes the credentials in
the \code{Authorization} header, splits it into username and password and then
calls the \code{validate} function provided at construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardBasic$check_request(request, response, keys, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request to validate as a \link[reqres:Request]{Request}
object}

\item{\code{response}}{The corresponding response to the request as a
\link[reqres:Response]{Response} object}

\item{\code{keys}}{A named list of path parameters from the path matching}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardBasic-reject_response"></a>}}
\if{latex}{\out{\hypertarget{method-GuardBasic-reject_response}{}}}
\subsection{Method \code{reject_response()}}{
Upon rejection this scheme sets the response status to \code{401}
and sets the \code{WWW-Authenticate} header to
\verb{Basic realm="<realm>", charset=UTF-8}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardBasic$reject_response(response, scope, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{The response object}

\item{\code{scope}}{The scope of the endpoint}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GuardBasic-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GuardBasic-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuardBasic$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
