% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffp_moments.R
\name{ffp_moments}
\alias{ffp_moments}
\alias{ffp_moments.default}
\alias{ffp_moments.numeric}
\alias{ffp_moments.matrix}
\alias{ffp_moments.xts}
\alias{ffp_moments.data.frame}
\alias{ffp_moments.tbl_df}
\title{Moments with Flexible Probabilities}
\usage{
ffp_moments(x, p = NULL)

\method{ffp_moments}{default}(x, p = NULL)

\method{ffp_moments}{numeric}(x, p = NULL)

\method{ffp_moments}{matrix}(x, p = NULL)

\method{ffp_moments}{xts}(x, p = NULL)

\method{ffp_moments}{data.frame}(x, p = NULL)

\method{ffp_moments}{tbl_df}(x, p = NULL)
}
\arguments{
\item{x}{A tabular (non-tidy) data structure.}

\item{p}{An object of the \code{ffp} class.}
}
\value{
A \code{list} with 2 elements: \code{mu} and \code{sigma}.
}
\description{
Computes the location and dispersion statistics under flexible probabilities.
}
\examples{
x <- matrix(diff(log(EuStockMarkets)), ncol = 4)
colnames(x) <- colnames(EuStockMarkets)
p <- stats::runif(nrow(x))
p <- p / sum(p)

ffp_moments(x = x, p = p)

# compare with the standard approach
colMeans(x)
cov(x)
}
