% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facsimile.R
\name{get_facsimile}
\alias{get_facsimile}
\alias{get_ubpr_facsimile}
\title{Retrieve Facsimile}
\usage{
get_facsimile(
  user_id = Sys.getenv("FFIEC_USER_ID"),
  bearer_token = Sys.getenv("FFIEC_BEARER_TOKEN"),
  reporting_period_end_date,
  fi_id_type = c("ID_RSSD", "FDICCertNumber", "OCCChartNumber", "OTSDockNumber"),
  fi_id
)

get_ubpr_facsimile(
  user_id = Sys.getenv("FFIEC_USER_ID"),
  bearer_token = Sys.getenv("FFIEC_BEARER_TOKEN"),
  reporting_period_end_date,
  fi_id_type = c("ID_RSSD", "FDICCertNumber", "OCCChartNumber", "OTSDockNumber"),
  fi_id
)
}
\arguments{
\item{user_id}{(String) The UserID for authenticating against the FFIEC API}

\item{bearer_token}{(String) The Bearer Token for authenticating against the
FFIEC API}

\item{reporting_period_end_date}{(String) The reporting period end date,
formatted as "MM/DD/YYYY"}

\item{fi_id_type}{(String) The type of identifier being provided; one of
\code{c("ID_RSSD", "FDICCertNumber", "OCCChartNumber", "OTSDockNumber")};
default is "ID_RSSD"}

\item{fi_id}{(String) The financial institution's identifier (can also be
supplied as an integer instead of a string)}
}
\value{
A tibble containing the facsimile data.
}
\description{
Retrieves Call Report or UBPR facsimile data from the FFIEC
Central Data Repository API for the requested financial institution.
}
\examples{
if (!no_creds_available()) {
  # Assume you have set the following environment variables:
  # - FFIEC_USER_ID
  # - FFIEC_BEARER_TOKEN

  # Retrieve facsimile data for reporting period 2025-03-31 for institution
  # with ID RSSD "480228"
  get_facsimile(
    reporting_period_end_date = "03/31/2025",
    fi_id = 480228
  )

  # Retrieve UBPR facsimile data for reporting period 2025-03-31 for
  # instutition with FDIC Cert Number "3510"
  get_ubpr_facsimile(
    reporting_period_end_date = "03/31/2025",
    fi_id_type = "FDICCertNumber",
    fi_id = "3510"
  )
}
}
\references{
\url{https://cdr.ffiec.gov/public/Files/SIS611_-_Retrieve_Public_Data_via_Web_Service.pdf}
}
