% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda-spearman-test.R
\name{eda_spearman_test}
\alias{eda_spearman_test}
\title{Spearman Test for Autocorrelation}
\usage{
eda_spearman_test(data, alpha = 0.05)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}
}
\value{
A list containing the test results, including:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{alpha}: The significance level as specified in the \code{alpha} argument.
\item \code{null_hypothesis}: A string describing the null hypothesis.
\item \code{alternative_hypothesis}: A string describing the alternative hypothesis.
\item \code{rho}: Numeric vector of serial correlation estimates for lags \eqn{1} to \eqn{n-3}.
\item \code{least_lag}: The smallest lag at which the serial correlation is insignificant.
\item \code{significant}: Indicates whether the serial correlation is significant at each lag.
\item \code{reject}: If \code{TRUE}, the null hypothesis was rejected at significance \code{alpha}.
}
}
\description{
Performs the Spearman serial correlation test on annual maximum series data
to check for serial correlation at various lags. Reports the smallest lag
where the serial correlation is not statistically significant at the given
significance level (the \emph{least insignificant lag}).
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
eda_spearman_test(data)

}
\seealso{
\code{\link[stats:cor.test]{stats::cor.test()}}, \code{\link[=eda_bbmk_test]{eda_bbmk_test()}}, \code{\link[=plot_spearman_test]{plot_spearman_test()}}
}
