% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.distance.effdia.R
\name{metric.distance.effdia}
\alias{metric.distance.effdia}
\title{Effective Diameter}
\usage{
metric.distance.effdia(
  Network,
  probability = 0.95,
  error = 0.03,
  effective_rate = 0.9,
  Cores = detectCores(),
  full = TRUE
)
}
\arguments{
\item{Network}{The input network.}

\item{probability}{The confidence level probability}

\item{error}{The sampling error}

\item{effective_rate}{The effective rate (by default it is set to be 0.9)}

\item{Cores}{Number of cores to use in the computations. By default uses \emph{parallel} function \code{detecCores()}.}

\item{full}{It will calculate the popular full version by default.
If it is set to FALSE, the estimated diameter will be calculated.}
}
\value{
A real value.
}
\description{
Calculate the effective diameter of a graph.
}
\details{
The diameter is the largest shortest path lengths of all pairs of nodes in
graph \emph{Network}. \code{metric.distance.diameter} calculates the (estimated)
diameter of graph \emph{Network} with a justified error.
}
\examples{
\dontrun{
##Default function
x <-  net.erdos.renyi.gnp(1000,0.01)
metric.distance.effdia(x)
##Population APL
metric.distance.effdia(x, full=TRUE)
##Sampling at 99\% level with an error of 10\% using 5 cores
metric.distance.effdia(Network = x, probability=0.99, error=0.1, Cores=5)
}

}
\references{
Dijkstra EW. A note on two problems in connexion with
graphs:(numerische mathematik, _1 (1959), p 269-271). 1959.

Castro L, Shaikh N. Estimation of Average Path Lengths of Social
Networks via Random Node Pair Sampling. Department of Industrial Engineering, University of Miami. 2016.
}
\author{
Luis Castro, Nazrul Shaikh.
}
