% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vegIndices.r
\docType{data}
\name{vegIndices}
\alias{vegIndices}
\title{Table of vegetation indices that can be calculated from remote sensing surface reflectance data using \code{\link[=vegIndex]{vegIndex()}}. A near-comprehensive table of indices can be found on the \href{https://www.indexdatabase.de}{Index Database: A Database for Remote Sensing Indices}.}
\format{
An object of class \code{data.frame}.
}
\description{
A table of vegetation indices that ca be calculated using \code{\link[=vegIndex]{vegIndex()}}. Columns include:
\itemize{
\item `index``: Abbreviation of the index.
\item \code{definition}: Index name
\item \code{R}, \code{G}, \code{B}, \code{NIR}, \code{channel5}, \code{channel7}: Whether or not the index uses the red, green, blue, or near-infrared channels, and channels 5 and 7.
\item \code{soilLineslope}, \code{soilIntercept}, \code{soilNR}: Whether or not the index requires soil line slope, soil intercept, and a soil noise reduction factor.
}
}
\examples{

### vector data

library(sf)

# For vector data, we can use data(*) or fastData(*):
data(madCoast0) # same as next line
madCoast0 <- fastData("madCoast0") # same as previous
madCoast0
plot(st_geometry(madCoast0))

madCoast4 <- fastData("madCoast4")
madCoast4
plot(st_geometry(madCoast4), add = TRUE)

madRivers <- fastData("madRivers")
madRivers
plot(st_geometry(madRivers), col = "blue", add = TRUE)

madDypsis <- fastData("madDypsis")
madDypsis
plot(st_geometry(madDypsis), col = "red", add = TRUE)

### raster data

library(terra)

# For raster data, we can get the file directly or using fastData(*):
rastFile <- system.file("extdata/madElev.tif", package="fasterRaster")
madElev <- terra::rast(rastFile)

madElev <- fastData("madElev") # same as previous two lines
madElev
plot(madElev)

madForest2000 <- fastData("madForest2000")
madForest2000
plot(madForest2000)

madForest2014 <- fastData("madForest2014")
madForest2014
plot(madForest2014)

# multi-layer rasters
madChelsa <- fastData("madChelsa")
madChelsa
plot(madChelsa)

madPpt <- fastData("madPpt")
madTmin <- fastData("madTmin")
madTmax <- fastData("madTmax")
madPpt
madTmin
madTmax


# RGB raster
madLANDSAT <- fastData("madLANDSAT")
madLANDSAT
plotRGB(madLANDSAT, 4, 1, 2, stretch = "lin")

# categorical raster
madCover <- fastData("madCover")
madCover
madCover <- droplevels(madCover)
levels(madCover) # levels in the raster
nlevels(madCover) # number of categories
catNames(madCover) # names of categories table

plot(madCover)
}
\seealso{
\code{\link[=vegIndex]{vegIndex()}}
}
\keyword{Remote}
\keyword{sensing}
