% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_GRaster_functions_across_layers.r
\name{mean,GRaster-method}
\alias{mean,GRaster-method}
\alias{mean}
\alias{mmode,GRaster-method}
\alias{mmode}
\alias{median,GRaster-method}
\alias{median}
\alias{count,GRaster-method}
\alias{count}
\alias{sum,GRaster-method}
\alias{sum}
\alias{min,GRaster-method}
\alias{min}
\alias{max,GRaster-method}
\alias{max}
\alias{which.min,GRaster-method}
\alias{which.min}
\alias{which.max,GRaster-method}
\alias{which.max}
\alias{sdpop,numeric-method}
\alias{sdpop}
\alias{varpop,GRaster-method}
\alias{varpop}
\alias{varpop,numeric-method}
\alias{stdev,GRaster-method}
\alias{stdev}
\alias{var,GRaster-method}
\alias{var}
\alias{nunique,GRaster-method}
\alias{nunique}
\alias{skewness,GRaster-method}
\alias{skewness}
\alias{kurtosis,GRaster-method}
\alias{kurtosis}
\alias{range,GRaster-method}
\alias{range}
\alias{quantile,GRaster-method}
\alias{quantile}
\alias{anyNA,GRaster-method}
\alias{anyNA}
\alias{allNA,GRaster-method}
\alias{allNA}
\title{Mathematical operations on two or more GRasters}
\usage{
\S4method{mean}{GRaster}(x, na.rm = FALSE)

\S4method{mmode}{GRaster}(x, na.rm = FALSE)

\S4method{median}{GRaster}(x, na.rm = FALSE)

\S4method{count}{GRaster}(x)

\S4method{sum}{GRaster}(x, na.rm = FALSE)

\S4method{min}{GRaster}(x, na.rm = FALSE)

\S4method{max}{GRaster}(x, na.rm = FALSE)

\S4method{which.min}{GRaster}(x)

\S4method{which.max}{GRaster}(x)

\S4method{sdpop}{numeric}(x, na.rm = FALSE)

\S4method{varpop}{GRaster}(x, na.rm = FALSE)

\S4method{varpop}{numeric}(x, na.rm = FALSE)

\S4method{stdev}{GRaster}(x, pop = TRUE, na.rm = FALSE)

\S4method{var}{GRaster}(x, na.rm = FALSE)

\S4method{nunique}{GRaster}(x, na.rm = FALSE)

\S4method{skewness}{GRaster}(x, na.rm = FALSE)

\S4method{kurtosis}{GRaster}(x, na.rm = FALSE)

\S4method{range}{GRaster}(x, na.rm = FALSE)

\S4method{quantile}{GRaster}(x, prob, na.rm = FALSE)

\S4method{anyNA}{GRaster}(x)

\S4method{allNA}{GRaster}(x)
}
\arguments{
\item{x}{A \code{GRaster}. Typically, this raster will have two or more layers. Values will be calculated within cells across rasters.}

\item{na.rm}{Logical: If \code{FALSE} (default), of one cell value has an \code{NA}, the result will be \code{NA}. If \code{TRUE}, \code{NA}s are ignored.}

\item{pop}{Logical (for \code{stdev()}): If \code{TRUE} (default), calculate the population standard deviation across layers. If \code{FALSE}, calculate the sample standard deviation.}

\item{prob}{Numeric: Quantile to calculate. Used for \code{quantile()}.}
}
\value{
A \code{GRaster}.
}
\description{
These functions can be applied to a "stack" of \code{GRaster}s with two or more layers. They return a single-layered \code{GRaster}.  If you want to summarize across cells in a raster (e.g., calculate the mean value of all cells on a raster), use \code{\link[=global]{global()}}. Options include:
\itemize{
\item Numeration: \code{count()} (number of non-\code{NA} cells), \code{sum()}.
\item Central tendency: \code{mean()}, \code{mmode()} (mode), \code{median()}.
\item Extremes: \code{min()}, \code{max()}, \code{which.min()} (index of raster with the minimum value), \code{which.max()} (index of the raster with the maximum value)
\item Dispersion: \code{range()}, \code{stdev()} (standard deviation), \code{var()} (sample variance), \code{varpop()} (population variance), \code{nunique()} (number of unique values), \code{quantile()} (use argument \code{probs}), \code{skewness()}, and \code{kurtosis()}.
\item \code{NA}s: \code{anyNA()} (any cells are \code{NA}?), \code{allNA()} (are all cells \code{NA}?)
}
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Example data
madChelsa <- fastData("madChelsa")

# Convert a SpatRaster to a GRaster
chelsa <- fast(madChelsa)
chelsa # 4 layers

# Central tendency
mean(chelsa)
mmode(chelsa)
median(chelsa)

# Statistics
nunique(chelsa)
sum(chelsa)
count(chelsa)
min(chelsa)
max(chelsa)
range(chelsa)
skewness(chelsa)
kurtosis(chelsa)

stdev(chelsa)
stdev(chelsa, pop = FALSE)
var(chelsa)
varpop(chelsa)

# Which layers have maximum/minimum?
which.min(chelsa)
which.max(chelsa)

# Regression

# Note the intercept is different for fasterRaster::regress().
regress(chelsa)
regress(madChelsa, 1:nlyr(madChelsa))

# Note: To get quantiles for each layer, use global().
quantile(chelsa, 0.1)

# NAs
madForest2000 <- fastData("madForest2000")
forest2000 <- fast(madForest2000)
forest2000 <- project(forest2000, chelsa, method = "near")

chelsaForest <- c(chelsa, forest2000)

nas <- anyNA(chelsaForest)
plot(nas)

allNas <- allNA(chelsaForest)
plot(allNas)

}
}
