% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictionSet.R
\name{predictionSet}
\alias{predictionSet}
\title{Wrapper to obtain a prediction set for categorical data}
\usage{
predictionSet(
  Y,
  method = "FAB",
  alpha = 0.15,
  gamma = rep(1, length(Y)),
  category_names = 1:length(Y)
)
}
\arguments{
\item{Y}{Observed data vector}

\item{method}{Choice of prediction method. Options include FAB, direct, Bayes.}

\item{alpha}{Prediction mis-coverage rate}

\item{gamma}{Dirichlet prior concentration for FAB/Bayes methods}

\item{category_names}{Category names (optional)}
}
\value{
pred object containing prediction set and interval coverage
}
\description{
This function computes a prediction set from a number of methods.
}
\examples{

# obtain example categorical data
set.seed(1)
prob = rdirichlet(50:1)
y = rmultinom(1,15,prob)

fab.set = predictionSet(y,
  method = "FAB",
  gamma = c(50:1))
plot(fab.set)

}
