% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationarity_test.R
\name{stationarity_test}
\alias{stationarity_test}
\title{Functional Stationarity Test}
\usage{
stationarity_test(
  X,
  statistic = "Tn",
  critical = c("simulation", "resample"),
  perm_method = "separate",
  M = 1000,
  blocksize = 2 * ncol(X)^(1/5),
  TVE = 1,
  replace = TRUE,
  return.info = FALSE
)
}
\arguments{
\item{X}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{statistic}{String for test statistic. Options are integrated (\code{Tn})
and supremum (\code{Mn}). The default is \code{Tn}.}

\item{critical}{String for method of determining the critical values. Options
are \code{simulation} and \code{resample}. Default is \code{simulation}.}

\item{perm_method}{String for method of resampling. Options are \code{separate}
for block resampling and \code{overlapping} for sliding window.
Default is \code{separate}.}

\item{M}{Numeric for number of simulation to use in determining the null
distribution. Default is 1000.}

\item{blocksize}{Numeric for blocksize in resample test. Default is \eqn{2N^{1/5}}.}

\item{TVE}{Numeric for total variance explained when using PCA for
eigenvalues. Default is 1.}

\item{replace}{Boolean if replacement should be used for resample test. Thus,
this defines if a bootstrapped or permuted test is used. Default is TRUE.}

\item{return.info}{Boolean if all information on test statistic and null
distribution should be returned or just the p-value (default).}
}
\value{
List with the following elements:
\enumerate{
\item pvalue: p-value for the stationarity test.
\item statistic: test statistic from the test.
\item simulations: simulations which define the null distribution.
}
}
\description{
Stationarity test for functional time series with different methods on
determining the critical values of the test statistic. The Monte Carlo
method was constructed in Horvath et al. (2014), while the resample-based
methods have not been validated in the literature (use the provided option
at your discretion).
}
\examples{
res <- stationarity_test(
  generate_brownian_motion(100, v = seq(0, 1, length.out = 20)),
  critical = "resample", statistic = "Mn"
)
res2 <- stationarity_test(electricity)
}
\references{
Horvath, L., Kokoszka, P., & Rice, G. (2014). Testing
stationarity of functional time series. Journal of Econometrics,
179(1), 66-82.
}
