% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.R
\name{fchange}
\alias{fchange}
\title{Change Point Detection}
\usage{
fchange(
  X,
  method = c("characteristic", "mean", "robustmean", "eigenjoint", "eigensingle",
    "trace", "covariance", "projmean", "projdistribution"),
  statistic = c("Tn", "Mn"),
  critical = c("simulation", "resample", "welch"),
  type = c("single", "segmentation", "elbow"),
  resample_blocks = "separate",
  replace = TRUE,
  max_changes = min(ncol(X), 20),
  changes = NULL,
  blocksize = 2 * ncol(X)^(1/5),
  eigen_number = 3,
  h = 2 * ncol(X)^(1/5),
  M = 1000,
  J = 50,
  W = space_measuring_functions(X = X, M = 20, space = "BM"),
  K = bartlett_kernel,
  alpha = 0.05,
  cov.res = 30,
  weighting = 1/4,
  TVE = 0.95,
  trim_function = function(X) {
     0
 },
  errors = "L2",
  recommendation_change_points = 2,
  recommendation_improvement = 0.15,
  silent.binary = FALSE,
  ...
)
}
\arguments{
\item{X}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{method}{Method to compute change point. Options include:
'characteristic', 'mean', 'robustmean', 'eigenjoint', 'eigensingle', 'trace',
'covariance', 'projmean', and 'projdistribution'.}

\item{statistic}{String for the test statistic type: integrated, \code{Tn},
or supremum, \code{Mn}.}

\item{critical}{String for method of computing threshold. Options are
'simulation', 'resample', and 'welch'. Not all ways to compute the critical
thresholds are implemented for every method.}

\item{type}{String for the type of change point detection, single change
('single'), binary segmentation ('segmentation'), or elbow plots ('elbow').}

\item{resample_blocks}{String indicating the type of resample test to use.
Using \code{separate} gives blocks which are separate while \code{overlapping}
creates overlapping or sliding windows. When \code{blocksize=1} then these
will be identical.}

\item{replace}{Boolean for using a permutation or bootstrapped statistic when
\code{critical='resample'}.}

\item{max_changes}{Integer as the max number of changes to search when using
type is \code{elbow}.}

\item{changes}{Vector of change points to be given to the eigen test if the data
should be centered on these values first.}

\item{blocksize}{Integer for the width of the blocks when using a resampling
test. Can use \code{\link[=adaptive_bandwidth]{adaptive_bandwidth()}} if additional guidance is desired.}

\item{eigen_number}{Which eigenvalue or the number of eigenvalues which should be checked
in the eigenvalue tests.}

\item{h}{Number of lags used when computing long run covariance estimates. Used in
mean, characteristic, and eigenvalue tests.}

\item{M}{Number of simulations or permutations for critical values}

\item{J}{Resolution (J) in the characteristic method. The number of vectors
is defined by \code{W}.}

\item{W}{Space measuring functions used in characteristic method to explore
the functional space.}

\item{K}{Kernel function for use in characteristic, mean, eigen, covariance
and projmean.}

\item{alpha}{Significance in [0,1] for Welch approximation.}

\item{cov.res}{Resolution to use when computing covariance kernel changes.}

\item{weighting}{Weights used in covariance kernel method and pcadistribution.}

\item{TVE}{Total variance explained for projmean and projdistribution.}

\item{trim_function}{Trimming to be used in multiple change methods.}

\item{errors}{Type of errors used in elbow plot. Options are L2 and Trace.}

\item{recommendation_change_points}{Number of lags forward to examine in deciding automated
elbow plot recommendation.}

\item{recommendation_improvement}{Significant drop to look for in deciding automated elbow
plot recommendation.}

\item{silent.binary}{Boolean if output should be printed when running binary
segmentation.}

\item{...}{Unused additional parameters.}
}
\value{
When type is single, returns a list:
\enumerate{
\item pvalue: p-value for detection of a change point.
\item location: location of the most likely change.
}
When type is elbow:
\enumerate{
\item information: data.frame with the information on each change and the
decrease in variability.
\item plots: list of plots showing the variability decrease or improvement
\item suggestion: list with plot and algorithmic change suggestion. The
suggested changes are also returned.
}
When type is segmentation a data.frame with the locations and p-values is
returned.
}
\description{
Change point detection for dfts objects. Various change point methods
are given, where single or multiple changes can be detected. Multiple change
extensions currently include binary segmentation and elbow plots.
}
\examples{
res <- fchange(electricity$data[, 1:20], method = "characteristic", critical = "welch")
}
\references{
Aue, A., Rice, G., & Sonmez, O. (2018). Detecting and dating structural
breaks in functional data without dimension reduction. Journal of the Royal
Statistical Society. Series B, Statistical Methodology, 80(3), 509-529.

Wegner, L., Wendler, M. Robust change-point detection for
functional time series based on U-statistics and dependent wild bootstrap.
Stat Papers (2024).

Aue, A., Rice, G., & Sonmez, O. (2020). Structural break
analysis for spectrum and trace of covariance operators. Environmetrics
(London, Ont.), 31(1)

Horvath, L., Rice, G., & Zhao, Y. (2022). Change point analysis
of covariance functions: A weighted cumulative sum approach. Journal of
Multivariate Analysis, 189, 104877-.

Berkes, I., Gabrys, R.,Horvath, L. & P. Kokoszka (2009).,
\emph{Detecting changes in the mean of functional observations}
Journal of the Royal Statistical Society, Series B 71, 927-946

Aue, A., Gabrys, R.,Horvath, L. & P. Kokoszka (2009).,
\emph{Estimation of a change-point in the mean function of functional data}
Journal of Multivariate Analysis 100, 2254-2269.

Huskova, M., & Meintanis, S.G. (2006). Change Point Analysis
based on Empirical Characteristic Functions. Metrika, 63, 145-168.
}
