% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC-table.R
\name{EC_table}
\alias{EC_table}
\title{Function to generate a table of EC values from a data frame of multiple
isolates.}
\usage{
EC_table(x, form = NULL, model = "LL.3", response = c(10, 50, 90),
  idcol = "ID", result = "df", plot = TRUE, ...)
}
\arguments{
\item{x}{a data frame that has at least the columns listed in the \code{form}
argument (e.g. "response" and "dose", see examples).}

\item{form}{a formula specifying the column names for the response and dose.
Defaults to NULL.}

\item{model}{one of 4 options:
\itemize{
   \item LL.3 = Log Logistic 3 parameter with a lower limit of 0.
   \item LL.4 = Log Logistic 4 parameter with lower limit estimated.
   \item W1.4 = Weibul 4 parameter type 1.
   \item W2.4 = Weibul 4 parameter type 2.
}}

\item{response}{a numeric vector specifying what EC values you want to calculate.}

\item{idcol}{the name of the column that identifies the samples (case sensitive).}

\item{result}{What result do you want returned? Default is "df" for a data
frame of summary values. If you want the models returned, choose "model".
If you want the summary output of the model, choose "summary".}

\item{plot}{if \code{TRUE}, a curve will be plotted for each sample.}

\item{...}{parameters passed on to \code{\link[utils]{read.table}} if
\code{x} is a file name.}
}
\value{
a data frame that contains EC estimates and standard errors in
  columns and samples in rows.
}
\description{
Function to generate a table of EC values from a data frame of multiple
isolates.
}
\examples{
data(dummydata)
# Using 3 parameter Log-Logistic Model (default)
EC_table(dummydata, form = response ~ dose)

# Using 4 parameter Weibull Model.
EC_table(dummydata, form = response ~ dose, model = "W2.4")

# This function really only needs three columns.
newdat <- dummydata[c("ID", "dose", "response")]
EC_table(newdat, form = response ~ dose)

# We can rename them, too.
colnames(newdat) <- c("identity", "dosage", "growth")
EC_table(newdat, form = growth ~ dosage, idcol = "identity")
}
\author{
Zhian N. Kamvar
}

