% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-epoch.R
\name{epoch_and_baseline_block}
\alias{epoch_and_baseline_block}
\title{Block-by-block epoch and baseline handler}
\usage{
epoch_and_baseline_block(
  x,
  blk,
  lab,
  evs,
  lims,
  msg_s,
  msg_e,
  c_bline,
  a_bline,
  bline_type,
  bline_evs,
  bline_per,
  hz,
  verbose
)
}
\arguments{
\item{x}{An object of class \code{eyeris} derived from \code{\link[=load_asc]{load_asc()}}}

\item{blk}{A list containing block metadata}

\item{lab}{Label for the epoch output}

\item{evs}{Events specification for epoching (character vector or list)}

\item{lims}{Time limits for epochs (numeric vector)}

\item{msg_s}{Start message string}

\item{msg_e}{End message string}

\item{c_bline}{Logical indicating whether to calculate baseline}

\item{a_bline}{Logical indicating whether to apply baseline correction}

\item{bline_type}{Type of baseline correction ("sub" or "div")}

\item{bline_evs}{Events specification for baseline calculation}

\item{bline_per}{Baseline period specification}

\item{hz}{Sampling rate in Hz}

\item{verbose}{A flag to indicate whether to print detailed logging messages}
}
\value{
A list containing epoch and baseline results
}
\description{
This function processes a single block of pupil data to extract epochs and
optionally compute and apply baseline corrections. It handles the core
epoching and baselining logic for a single block of data.
}
\details{
This function is called by the internal \code{\link[=epoch_pupil]{epoch_pupil()}} function.
}
\keyword{internal}
