% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{explain_tree}
\alias{explain_tree}
\title{Explain a target using a simple decision tree (classification or regression)}
\usage{
explain_tree(
  data,
  target,
  n,
  max_cat = 10,
  max_target_cat = 5,
  maxdepth = 3,
  minsplit = 20,
  cp = 0,
  weights = NA,
  size = 0.7,
  out = "plot",
  ...
)
}
\arguments{
\item{data}{A dataset}

\item{target}{Target variable}

\item{n}{weights variable (for count data)}

\item{max_cat}{Drop categorical variables with higher number of levels}

\item{max_target_cat}{Maximum number of categories to be plotted for target (except NA)}

\item{maxdepth}{
    Set the maximum depth of any node of the final tree, with the root
    node counted as depth 0.  Maximum value 30 (as node numbers have to
    be stored in 32-bit signed integer types).
  }

\item{minsplit}{
    the minimum number of observations that must exist in a node in order for 
    a split to be attempted. 
  }

\item{cp}{
    complexity parameter.  Any split that does not decrease the overall
    lack of fit by a factor of \code{cp} is not attempted.  For instance,
    with \code{anova} splitting, this means that the overall R-squared must
    increase by \code{cp} at each step. The main role of this parameter
    is to save computing time by pruning off splits that are obviously
    not worthwhile. Essentially,the user informs the program that any
    split which does not improve the fit by \code{cp} will likely be
    pruned off by cross-validation, and that hence the program need
    not pursue it.
  }

\item{weights}{optional case weights.}

\item{size}{Text size of plot}

\item{out}{Output of function: "plot" | "model"}

\item{...}{Further arguments}
}
\value{
Plot or additional the model (if out = "model")
}
\description{
Explain a target using a simple decision tree (classification or regression)
}
\examples{
data <- iris
data$is_versicolor <- ifelse(iris$Species == "versicolor", 1, 0)
data$Species <- NULL
explain_tree(data, target = is_versicolor)
}
