% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eROC_plot.R
\name{eROC_plot}
\alias{eROC_plot}
\title{Enhanced ROC and Precision-Recall Plots}
\usage{
eROC_plot(task, trained_model, splits)
}
\arguments{
\item{task}{mlr3 binary classification task object specifying the task details}

\item{trained_model}{mlr3 trained learner (model) object obtained after training}

\item{splits}{mlr3 object defining data splits for train and test sets}
}
\value{
ROC and Precision-Recall curves
}
\description{
This function generates Precision-Recall and ROC curves for binary classification models.
}
\examples{
library("explainer")
seed <- 246
set.seed(seed)
# Load necessary packages
if (!requireNamespace("mlbench", quietly = TRUE)) stop("mlbench not installed.")
if (!requireNamespace("mlr3learners", quietly = TRUE)) stop("mlr3learners not installed.")
if (!requireNamespace("ranger", quietly = TRUE)) stop("ranger not installed.")
# Load BreastCancer dataset
utils::data("BreastCancer", package = "mlbench")
target_col <- "Class"
positive_class <- "malignant"
mydata <- BreastCancer[, -1]
mydata <- na.omit(mydata)
sex <- sample(
  c("Male", "Female"),
  size = nrow(mydata),
  replace = TRUE
)
mydata$age <- as.numeric(sample(
  seq(18, 60),
  size = nrow(mydata),
  replace = TRUE
))
mydata$sex <- factor(
  sex,
  levels = c("Male", "Female"),
  labels = c(1, 0)
)
maintask <- mlr3::TaskClassif$new(
  id = "my_classification_task",
  backend = mydata,
  target = target_col,
  positive = positive_class
)
splits <- mlr3::partition(maintask)
mylrn <- mlr3::lrn(
  "classif.ranger",
  predict_type = "prob"
)
mylrn$train(maintask, splits$train)
myplot <- eROC_plot(
  task = maintask,
  trained_model = mylrn,
  splits = splits
)
}
