% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewp_reg.R
\name{ewp_reg}
\alias{ewp_reg}
\title{Exponentially weighted Poisson regression model}
\usage{
ewp_reg(
  formula,
  family = "ewp3",
  data,
  verbose = TRUE,
  method = "Nelder-Mead",
  hessian = TRUE,
  autoscale = TRUE,
  maxiter = 500,
  sum_limit = round(max(Y) * 3),
  start_val = NULL
)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{family}{choice of "ewp2" or "ewp3"}

\item{data}{a data frame containing the variables in the model.}

\item{verbose}{logical, defaults to TRUE; print model fitting progress}

\item{method}{string, passed to optim, defaults to 'BFGS'}

\item{hessian}{logical, defaults to TRUE; calculate Hessian?}

\item{autoscale}{logical, defaults to TRUE; automatically scale model parameters inside the optimisation routine based on initial estimates from a Poisson regression.}

\item{maxiter}{numeric, maximum number of iterations for optim}

\item{sum_limit}{numeric, defaults to 3*maximum count; upper limit for the sum used for the normalizing factor.}

\item{start_val}{list, defaults to fitting a Poisson regression; specify starting values}
}
\value{
an ewp model
}
\description{
Exponentially weighted Poisson regression model
}
