% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extended_EWOC.R
\name{mtd_rho_d1extended}
\alias{mtd_rho_d1extended}
\title{Convert mtd to rho_1 and vice-versa}
\usage{
mtd_rho_d1extended(mtd = NULL, rho_1 = NULL, rho_0, theta, min_dose, max_dose)
}
\arguments{
\item{mtd}{a numerical value defining the mtd value to be converted into rho_1 value.}

\item{rho_1}{a numerical value defining the  probability of DLT at the max_dose.}

\item{rho_0}{a numerical value defining the  probability of DLT at the min_dose.}

\item{theta}{a numerical value defining the proportion of expected patients
to experience a medically unacceptable, dose-limiting toxicity (DLT) if
administered the MTD.}

\item{min_dose}{a numerical value defining the lower bound of the support of
the MTD.}

\item{max_dose}{a numerical value defining the upper bound of the support of
the MTD.}
}
\value{
\code{mtd} a numerical value for the maximum tolerable dose.

\code{rho_1} a numerical value for the probability of DLT at the max_dose.
}
\description{
Converting mtd to rho_1 given rho_0 for EWOC design using extended parametrization
and vice-versa.
}
