% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operating_characteristics.R
\name{accuracy_index}
\alias{accuracy_index}
\title{Accuracy Index}
\usage{
accuracy_index(
  mtd_estimate,
  dose_set,
  true_prob,
  theta,
  loss = c("squared", "absolute", "classification", "overdose"),
  alpha = NULL
)
}
\arguments{
\item{mtd_estimate}{a numerical vector of the MTD estimates.}

\item{dose_set}{a numerical vector of allowable doses in the trial.}

\item{true_prob}{a numerical vector of the true probabilities associated
with 'dose_set'.}

\item{theta}{a numerical value defining the proportion of expected patients
to experience a medically unacceptable, dose-limiting toxicity (DLT) if
administered the MTD.}

\item{loss}{a loss function between the true probabilities of toxicity
'true_prob' and the target DLT rate 'theta'.}

\item{alpha}{a numerical value indicating the weight of overdose for the
overdose loss function.}
}
\value{
Accuracy Index for given loss function of the MTD estimates.
}
\description{
Calculate the Accuracy Index.
}
\references{
Cheung, Y. K. (2011). Dose finding by the continual reassessment method. CRC Press.
}
