% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_functions_3d.R
\name{stats_3d}
\alias{stats_3d}
\title{Computes mean and standard deviation}
\usage{
stats_3d(dat)
}
\arguments{
\item{dat}{The data array}
}
\value{
A list with following components
\item{\code{mean.dat}}{The mean of the data array}
\item{\code{sd.dat}}{The standard deviation of the data array}
}
\description{
This function is used for 3D event extraction and feature computation.
}
\examples{
set.seed(1)
arr <- array(rnorm(12000),dim=c(40,25,30))
arr[25:33,12:20, 20:23] <- 10
mean_sd <- stats_3d(arr[1:20,1:6,1:8])
mean_sd
}
