% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_mode.R
\name{calc_mode}
\alias{calc_mode}
\title{Calculate mode with optional tie-breaks}
\usage{
calc_mode(x, tie_break = NULL, second_tie_break = NULL)
}
\arguments{
\item{x}{A character vector for which to find the mode.}

\item{tie_break}{An optional numeric vector used as the first tie-break criterion.}

\item{second_tie_break}{An optional numeric vector used as the second tie-break criterion when the first is insufficient.}
}
\value{
Returns the mode of `x`. If there are multiple modes and no tie-breaks are specified or they do not resolve the ties, returns "Indeterminate".
}
\description{
This function calculates the mode of a given vector and optionally resolves ties using one or two levels of tie-breaks.
}
\examples{
data <- c("apple", "apple", "banana", "banana")
tie_break <- c(1, 2, 1, 2)
second_tie_break <- c(1, 1, 2, 1)
calc_mode(data)  # Expect: "Indeterminate"
calc_mode(data, tie_break)  # Expect: "Indeterminate"
calc_mode(data, tie_break, second_tie_break)  # Expect: "banana"
}
