% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proDSinit.R
\name{proDSinit}
\alias{proDSinit}
\title{Initialization of parameters for the evidential neural network classifier}
\usage{
proDSinit(x, y, nproto, nprotoPerClass = FALSE, crisp = FALSE)
}
\arguments{
\item{x}{Input matrix of size n x d, where n is the number of objects and d the number of
attributes.}

\item{y}{Vector of class labels (of length n). May be a factor, or a vector of
integers from 1 to M (number of classes).}

\item{nproto}{Number of prototypes.}

\item{nprotoPerClass}{Boolean. If TRUE, there are \code{nproto} prototypes per class. If
FALSE (default), the total number of prototypes is equal to \code{nproto}.}

\item{crisp}{Boolean. If TRUE, the prototypes have full membership to only one class. (Available only if
nprotoPerClass=TRUE).}
}
\value{
A list with four elements containing the initialized network parameters
  \describe{
  \item{alpha}{Vector of length r, where r is the number of prototypes.}
  \item{gamma}{Vector of length r}
  \item{beta}{Matrix of size (r,M), where M is the number of classes.}
  \item{W}{Matrix of size (r,d), containing the prototype coordinates.}
 }
}
\description{
\code{proDSinit} returns initial parameter values for the evidential neural network classifier.
}
\details{
The prototypes are initialized by the k-means algorithms. The initial membership values \eqn{u_{ik}} of
each prototype \eqn{p_i} to class \eqn{\omega_k} are normally defined as the proportion of training samples
from class \eqn{\omega_k} in the neighborhood of prototype \eqn{p_i}. If arguments \code{crisp} and
\code{nprotoPerClass} are set to TRUE, the prototypes are assigned to one and only one class.
}
\examples{
## Glass dataset
data(glass)
xapp<-glass$x[1:89,]
yapp<-glass$y[1:89]
param0<-proDSinit(xapp,yapp,nproto=7)
param0
}
\references{
T. Denoeux. A neural network classifier based on Dempster-Shafer theory.
IEEE Trans. on Systems, Man and Cybernetics A, 30(2):131--150, 2000.
}
\seealso{
\code{\link{proDSfit}}, \code{\link{proDSval}}
}
\author{
Thierry Denoeux.
}
