% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_conv.R
\name{uv2wd}
\alias{uv2wd}
\title{Function to calculate model wind direction}
\usage{
uv2wd(u, v, verbose = TRUE)
}
\arguments{
\item{u}{data.frame with model time-series of U10}

\item{v}{data.frame with model time-series of V10}

\item{verbose}{display additional information}
}
\value{
vector or data.frame with time and the wind direction, units are degree north
}
\description{
Function to calculate model wind direction
}
\examples{
times <- seq(as.POSIXct('2024-01-01',tz = 'UTC'),
             as.POSIXct('2024-01-02',tz = 'UTC'),
             by = 'hour')
U10 = data.frame(times = times,
                 test1 = c(3.29,2.07,1.96,2.82,3.73,
                           4.11,4.96,6.33,7.39,7.59,
                           7.51,7.22,6.81,6.43,5.81,
                           4.02,3.03,2.68,2.40,2.20,
                           2.09,1.95,1.66,1.39,1.4),
                 test2 = c(6.29,4.87,6.16,7.12,8.77,
                           10.16,10.85,11.45,11.21,11.04,
                           11.09,10.67,10.48,10.00,8.96,
                           6.36,5.62,5.83,5.83,5.25,
                           4.11,3.08,2.26,1.14,-0.10))
V10 = data.frame(times = times,
                 test1 = c(-8.87,-4.23,-2.81,-2.59,-4.58,
                           -4.80,-5.33,-5.86,-6.12,-6.13,
                           -6.11,-5.76,-5.91,-5.60,-5.09,
                           -3.33,-2.50,-2.29,-2.14,-2.07,
                           -1.95,-1.97,-2.04,-2.03,-1.9),
                 test2 = c(11.80,5.88,5.74,5.56,6.87,
                           8.39,8.68,8.33,7.90,7.42,
                           6.96,6.87,6.36,5.61,5.16,
                           4.16,4.25,4.59,4.51,3.90,
                           2.97,1.98,1.04,-0.08,-0.44))

uv2wd(u = U10, v = V10)

}
