% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resistance.R
\name{resistance}
\alias{resistance}
\title{Calculate the resistance of a state variable to disturbance}
\usage{
resistance(
  type,
  res_mode = NULL,
  res_time = NULL,
  res_t = NULL,
  res_tf = NULL,
  b = NULL,
  b_tf = NULL,
  vb_i = NULL,
  tb_i = NULL,
  b_data = NULL,
  vd_i = NULL,
  td_i = NULL,
  d_data = NULL,
  comm_b = NULL,
  comm_d = NULL,
  comm_t = NULL,
  method = "bray",
  binary = "FALSE",
  na_rm = TRUE
)
}
\arguments{
\item{type}{a string defining the type of stability (\code{"functional"} or \code{"compositional"}) to be calculated.}

\item{res_mode}{A string stating whether the resistance should be calculated
as the log response ratio of the state variable in the disturbed system
compared to the baseline (\code{res_mode = "lrr"}) or the difference
(\code{res_mode = "diff"}) between the values of these state variables.
See details.}

\item{res_time}{A string stating whether resistance should be calculated at
a specific point in time (\code{res_time = "defined"}) or if it should be
taken as the maximal difference between the disturbed and baseline state
variables over a specified time period (\code{res_time = "max"}).
Time point and the time period are defined by \code{res_t} and
\code{res_tf}, respectively.
See details.}

\item{res_t}{An integer defining the time point when resistance should be
measured if \code{res_time = "defined"}.}

\item{res_tf}{A vector, specifying the time period for which the maximum
resistance should be looked for, if \code{res_time = "max"}.}

\item{b}{a string stating whether the baseline is defined by a separate
baseline that is specified by the user (\code{b = "input"}) or by a
period of the disturbed system (\code{b = "d"}) prior to the disturbance.
This period is specified by \code{b_tf}.}

\item{b_tf}{a numerical vector, specifying the beginning and end of the
pre-disturbance time period for the disturbed time-series that defines
the baseline. Obligatory if (\code{b = "d"}), see 'Details'.}

\item{vb_i}{an optional numeric vector containing the state variable in
the baseline, or a string for the name of the column in \code{b_data}
containing said variable in the dataframe with baseline values.}

\item{tb_i}{an optional numeric vector containing the time period over which
the baseline was measured, or a string for the name of the column in
\code{b_data} containing said the time variable in the dataframe
with baseline values.}

\item{b_data}{an optional data frame containing the time series of the
state variable values in the baseline.}

\item{vd_i}{a numeric vector containing the state variable in the
disturbed system or a string specifying the name of the column
containing said variable in the dataframe provided in \code{d_data}.}

\item{td_i}{a numeric vector containing the time or a string specifying the
name of the column containing the time in the dataframe provided
in \code{d_data}.}

\item{d_data}{an optional data frame containing the time series of the
state variable values in a disturbed system.}

\item{comm_b}{a data frame containing long format community data (species
names as columns over time as rows) to calculate compositional metrics.}

\item{comm_d}{a data frame containing long format community data
(species as columns over time as rows) to calculate compositional metrics.}

\item{comm_t}{an optional string with the name of the time variable in the
community data. Only necessary when calculating maximal resistance.}

\item{method}{a string identifying the dissimilarity index to be used to
calculate dissimilarity. For more options, see \code{?vegdist}.
Defaults to "bray".}

\item{binary}{a boolean stating whether presence/absence standardization
should be performed before calculating the dissimilarity. For more options,
see \code{?vegdist}. Defaults to "bray".}

\item{na_rm}{a logical determining whether NAs should be taken out prior
to the estimation of the stability metric. Defaults to TRUE.}
}
\value{
A numeric, the resistance value. Maximum (functional and
compositional) recovery at 0. For functional stability, smaller or higher
values indicate under- or overcompensation, respectively. For compositional
stability using the Bray-Curtis index (default),
\eqn{0 \le R \le 1}
, and the maximal resistance is 0. The higher the index, the more apart the
communities are and thus, the lower resistance is.
}
\description{
\code{resistance} ( \eqn{R} ) returns either the distance of a state variable to
a baseline value at a specified time point or a maximum distance between the
state variables in the disturbed system and the baseline over a specified
period. For functional stability, the  distance can be calculated as the
log-response ratio or as the difference between the state variables in a
disturbed time-series and the baseline. For community stability, the distance
is calculated as the dissimilarity between the disturbed and baseline
communities.
}
\details{
For functional stability, resistance can be calculated as:
\itemize{
\item The log response ratio or absolute difference
between  the state variable’s value in the disturbed
\eqn{v_d}
and the baseline
( \eqn{v_b} or \eqn{v_p} if the baseline is pre-disturbance values),
on the user-defined time step. Therefore,
\eqn{R = \log\!\left(\frac{v_d(t)}{v_b(t)}\right)}
, or
\eqn{R = \log\!\left(\frac{v_d(t)}{v_p(t)}\right)}
, or
\eqn{R = \lvert v_d(t) - v_b(t) \rvert}
, or
\eqn{R = \lvert v_d(t) - v_p(t) \rvert}
.
\item The maximal log response ratio or absolute difference between the state
variable’s value in the disturbed and the baseline systems, over a
user-defined time interval:
\eqn{R = \max_t(\log\!\left(\frac{v_d(t)}{v_b(t)}\right))}
, or
\eqn{R = \max_t(\log\!\left(\frac{v_d(t)}{v_p(t)}\right))}
, or
\eqn{R = \max_t(\lvert v_d(t) - v_b(t) \rvert)}
, or
\eqn{R = \max_t(\lvert v_d(t) - v_p(t) \rvert)}
.
}

For compositional stability, the dissimilarity between disturbed
( \eqn{C_d} )
and baseline
( \eqn{C_b} )
communities at user-defined time step
\eqn{R = \mathrm{dissim}\!\left(\frac{C_d(t)}{C_b(t)}\right)}
, or the maximal value
\eqn{R = \max_t (\mathrm{dissim}\!\left(\frac{C_d(t)}{C_b(t)}\right))}
.

If resistance is calculated at a specific time point, it is
conventionally the first time point after the disturbance.

Even though it is possible to use a single data value as baseline
(by passing a double to \code{b_tf}), it is not recommended, because a
single value does not account for any variability in the system arising from,
for example, demographic or environmental stochasticity.
}
\examples{
resistance(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "input",
  vb_i = "statvar_bl", tb_i = "time", b_data = aquacomm_resps,
  res_mode = "lrr", res_time = "defined", res_t = 12, type = "functional"
)
resistance(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "input",
  vb_i = "statvar_bl", tb_i = "time", b_data = aquacomm_resps,
  type = "functional", res_mode = "diff", res_time = "defined", res_t = 12
)
resistance(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "d",
  b_tf = 8, type = "functional", res_mode = "lrr",
  res_time = "defined", res_t = 12
)
resistance(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "d",
  b_tf = 8, type = "functional", res_mode = "diff",
  res_time = "defined", res_t = 12
)
resistance(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "input",
  vb_i = "statvar_bl", tb_i = "time", b_data = aquacomm_resps,
  type = "functional", res_mode = "lrr", res_time = "max", res_tf = c(12, 51)
)
resistance(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "input",
  vb_i = "statvar_bl", tb_i = "time", b_data = aquacomm_resps,
  type = "functional", res_mode = "diff", res_time = "max", res_tf = c(12, 51)
)
resistance(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "d",
  type = "functional", res_mode = "lrr", b_tf = 8, res_time = "max",
  res_tf = c(12, 51)
)
resistance(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "d",
  type = "functional", res_mode = "lrr", b_tf = 8, res_time = "max",
  res_tf = c(12, 51)
)
resistance(
  type = "compositional", res_time = "defined", res_t = 28, comm_d = comm_dist,
  comm_b = comm_base, comm_t = "time"
)
}
