% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Individual.R
\name{individual}
\alias{individual}
\title{Return individual average raw data and plotted waveforms (optional) for all loaded conditions}
\usage{
individual(data, electrodes, plots = "n")
}
\arguments{
\item{data}{A data frame in the format returned from \code{\link{load.data}}}

\item{electrodes}{A single value or concatenation of several values (to be averaged)
indicating which electrodes to include in generating the plot. At this time, if the
raw data files imported using \code{\link{load.data}}) do not have a header, you
must include a capital "V" in front of the number and enclose each electrode in quotes.
(For example, electrodes = "V78", or electrodes = c("V78", "V76").)}

\item{plots}{Creates plots of individual averaged data in separate windows. By default,
plots are suppressed, but can be activated by setting \code{plots} to "y".}
}
\value{
Data frame of individual average data for each subject in each condition.
  If \code{plot = "y"}, then multiple plots (1 per subject) will also be generated.
}
\description{
\code{individual} plots individual, averaged waveforms for each condition present in the
  data frame you provide.  Separate plots for each individual can be generated, if specified.
}
\details{
\code{individual} will generate individual average data and separate plots of
  averaged waveforms (optional) for each subject in the data frame you provide.  Raw data are
  organized in columns by subject and condition. Plots will be generated by setting
  \code{plots = "y"}.

  Single electrodes can be passed to the package functions,
  or several electrodes can be provided (i.e., when using dense arrays) and those electrodes
  will be averaged together as a single electrode.
}
\examples{
# Return data frame of individual average data and create average waveform
# plots for each subject
individual(ERPdata, electrodes = "V78", plots="y")

}
\author{
Travis Moore
}
