% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{b2concurrent-ergmTerm}
\alias{b2concurrent-ergmTerm}
\alias{InitErgmTerm.b2concurrent}
\title{Concurrent node count for the second mode in a bipartite network}
\usage{
# binary: b2concurrent(by=NULL)
}
\arguments{
\item{by}{This optional argument specifie a vertex attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details);
it functions just like the \code{by} argument of the \code{b2degree} term.}
}
\description{
This term adds one
network statistic to the model, equal to the number of nodes in the second
mode of the network with degree 2 or higher. The second mode of a bipartite
network object is sometimes known as the "event" mode.
Without the optional argument, this statistic is equivalent to \code{b2mindegree(2)}.
}
\note{
This term can only be used with undirected bipartite networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b2concurrent", "subsection")}
}
\concept{bipartite}
\concept{frequently-used}
\concept{undirected}
