% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_devlin.R
\name{figure_1_2_5}
\alias{figure_1_2_5}
\title{Figure 1.2.5: Health Profile Grid (HPG) for Two Time Points}
\usage{
figure_1_2_5(
  df,
  names_eq5d,
  name_fu,
  levels_fu = NULL,
  name_id,
  eq5d_version,
  country
)
}
\arguments{
\item{df}{A data frame containing EQ-5D columns, a grouping variable, an ID column, and a follow-up column}

\item{names_eq5d}{A character vector of EQ-5D dimension names}

\item{name_fu}{A character string for the follow-up column}

\item{levels_fu}{A character vector of length 2, specifying the order of the follow-up levels (e.g., c("Pre-op","Post-op"))}

\item{name_id}{A character string for the patient ID column}

\item{eq5d_version}{Version of the EQ-5D instrument}

\item{country}{A character string representing the name of the country.}
}
\value{
A list with components:
  \item{plot_data}{The plot data with ranks and classification.}
  \item{p}{A \code{ggplot2} object displaying the HPG scatter plot.}
}
\description{
This function creates a Health Profile Grid (HPG) for EQ-5D data, plotting each
individual's change in health states (ranked from best to worst) between two time
points. A diagonal reference line indicates no change; points above the line reflect
improvement, and points below indicate deterioration.
}
\examples{
tmp <- figure_1_2_5(
           df = example_data, 
           names_eq5d = c("mo", "sc", "ua", "pd", "ad"), 
           name_fu = "time", 
           levels_fu = c("Pre-op", "Post-op"), 
           name_id = "id", 
           eq5d_version = "3L", 
           country = "UK"
       )
}
