% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_aux.R
\name{.pchctab}
\alias{.pchctab}
\title{.pchctab: Changes in health according to the PCHC (Paretian Classification of Health Change)}
\usage{
.pchctab(
  df,
  name_id,
  name_groupvar,
  names_eq5d = NULL,
  name_fu = NULL,
  levels_fu = NULL,
  add_noprobs = FALSE
)
}
\arguments{
\item{df}{Data frame with the EQ-5D, grouping, id and follow-up columns}

\item{name_id}{Character string for the patient id column}

\item{name_groupvar}{Character string for the grouping column}

\item{names_eq5d}{Character vector of column names for the EQ-5D dimensions}

\item{name_fu}{Character string for the follow-up column}

\item{levels_fu}{Character vector containing the order of the values in the follow-up column. 
If NULL (default value), the levels will be ordered in the order of appearance in df.}

\item{add_noprobs}{if set to TRUE, level corresponding to "no problems" will be added to the table}
}
\value{
Summary data frame
}
\description{
.pchctab: Changes in health according to the PCHC (Paretian Classification of Health Change)
}
\examples{
.pchctab(df = example_data, 
  name_id = "id", 
  name_groupvar = "procedure", 
  name_fu = "time", 
  levels_fu = c('Pre-op', 'Post-op')
)
}
