% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{get_idf_relation}
\alias{get_idf_relation}
\title{Extract object and value reference relations}
\usage{
get_idf_relation(
  idd_env,
  idf_env,
  object_id = NULL,
  value_id = NULL,
  direction = c("ref_to", "ref_by"),
  depth = 0L,
  name = FALSE,
  object = NULL,
  class = NULL,
  group = NULL,
  keep_all = FALSE,
  class_ref = c("both", "none", "all"),
  match_all = FALSE
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{object_id}{An integer vector of valid object IDs. If \code{NULL}, all object
IDs in current IDF will be used.}

\item{value_id}{An integer vector of valid value IDs. If \code{NULL}, all value
IDs in current IDF will be used.}

\item{direction}{Reference relation direction. Should be one of \code{"ref_to"}
and \code{"ref_by"}. Default: \code{"ref_to"}.}

\item{depth}{Recursive reference relation depth. \code{NULL} means infinite.
Default: \code{0L}.}

\item{name}{If \code{TRUE}, all class, object, field value ID and name columns
will be added and a \code{IdfRelationTo} or \code{IdfRelationBy} object is
returned with customized printing method. Default: \code{FALSE}.}

\item{object}{An integer vector of valid object IDs or a character vector
of valid object names to specify the targeting relation objects.
Default: \code{NULL}.}

\item{class}{An integer vector of valid class indexes or a character vector
of valid class names to specify the targeting relation classes.
Default: \code{NULL}.}

\item{group}{A character vector of valid group names to specify the targeting
relation groups. Default: \code{NULL}.}

\item{keep_all}{If \code{TRUE}, all input ID are kept. Otherwise, only input IDs
that have relations are kept. Default: \code{FALSE}.}

\item{class_ref}{Specify how to handle class-name-references. There are 3
options in total, i.e. \code{"none"}, \code{"both"} and \code{"all"}, with \code{"both"}
being the default.
* \code{"none"}: just ignore class-name-references.
* \code{"both"}: only include class-name-references if this object also
reference field values of the same one. This is the default option.
* \code{"all"}: include all class-name-references. This is the most aggressive
option.}

\item{match_all}{If \code{TRUE}, relation search will continue even though one
relation has been found. If \code{FALSE}, searching is stopped whenever one
relation is found in specified classes/groups. Default: \code{FALSE}.}
}
\value{
A data.table.
}
\description{
Extract object and value reference relations
}
\keyword{internal}
