% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_set_config_from_list}
\alias{epitrax_set_config_from_list}
\title{Set report configuration of EpiTrax object from list}
\usage{
epitrax_set_config_from_list(epitrax, config = NULL)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{config}{Optional list of config parameters. If omitted, default values will be used.}
}
\value{
Updated EpiTrax object with \code{config} field set.
}
\description{
\code{epitrax_set_config_from_list} sets the report configuration from the given list.
}
\examples{
config <- list(
 current_population = 56000,
 avg_5yr_population = 57000,
 rounding_decimals = 3,
 generate_csvs = FALSE
)
epitrax <- structure(
  list(data = c(1,2,3)),
  class = "epitrax"
)
epitrax <- epitrax_set_config_from_list(epitrax, config)
}
\seealso{
\code{\link[=epitrax_set_config_from_file]{epitrax_set_config_from_file()}} and the convenience function
\code{\link[=setup_epitrax]{setup_epitrax()}} which wraps this function
}
