% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_wiki}
\alias{pub_wiki}
\title{Wikipedia webpage counts by article}
\usage{
pub_wiki(
  articles,
  ...,
  time_type = c("day", "week"),
  time_values = "*",
  hours = NULL,
  language = "en",
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{articles}{character. Articles to fetch.}

\item{...}{not used for values, forces later arguments to bind by name}

\item{time_type}{string. The temporal resolution of the data (either "day" or
"week", depending on signal).}

\item{time_values}{\code{\link{timeset}}. Dates or epiweeks to fetch. Defaults to all
("*") dates.}

\item{hours}{integer. Optionally, the hours to fetch.}

\item{language}{string. Language to fetch.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/wiki.html}
Number of page visits for selected English, Influenza-related wikipedia articles.
\itemize{
\item Source: Wikimedia
\item Temporal Resolution: Hourly, daily, and weekly from 2007-12-09 (2007w50)
\item Spatial Resolution: N/A
\item Other resolution: By article (54)
\item Open access
}
}
\examples{
\dontrun{
pub_wiki(
  articles = "avian_influenza",
  time_type = "week",
  time_values = epirange(201501, 201601)
)
}
}
\keyword{endpoint}
