% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{get_api_key}
\alias{get_api_key}
\alias{save_api_key}
\title{Get and set API keys}
\usage{
get_api_key()

save_api_key()
}
\value{
For \code{get_api_key()}, returns the current API key as a string, or
\code{""} if none is set.
}
\description{
Get and set the API key used to make requests to the Epidata API. Without a
key, requests may be subject to rate limits and other limitations.
}
\details{
We recommend you register for an API key. While most endpoints are available
without one, there are \href{https://cmu-delphi.github.io/delphi-epidata/api/api_keys.html}{limits on API usage for anonymous users},
including a rate limit. If you regularly request large amounts of data,
please consider \href{https://api.delphi.cmu.edu/epidata/admin/registration_form}{registering for an API key}.

API keys are strings read from the environment variable \code{DELPHI_EPIDATA_KEY}.
We recommend setting your key with \code{save_api_key()}, which will modify an
applicable \code{.Renviron} file, which will be read in automatically when you
start future R sessions (see \code{\link[base:Startup]{?Startup}} for details on
\code{.Renviron} files). Alternatively, you can modify the environment variable at
the command line before/while launching R, or inside an R session with
\code{\link[=Sys.setenv]{Sys.setenv()}}, but these will not persist across sessions.

Once an API key is set, it is automatically used for all requests made by
functions in this package.
}
\references{
\itemize{
\item \href{https://cmu-delphi.github.io/delphi-epidata/api/api_keys.html}{Delphi Epidata API Keys documentation}.
\item \href{https://api.delphi.cmu.edu/epidata/admin/registration_form}{Delphi Epidata API Registration Form}.
}
}
