% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{calibration}
\alias{calibration}
\alias{print.calibration}
\alias{summary.calibration}
\alias{plot.calibration}
\alias{as.list.calibration}
\alias{lod}
\alias{lod.default}
\alias{lod.calibration}
\alias{loq}
\alias{loq.default}
\alias{loq.calibration}
\alias{predict.calibration}
\alias{inv_predict}
\alias{inv_predict.default}
\alias{inv_predict.calibration}
\title{Analytical calibration functions}
\usage{
calibration(
  formula,
  data = NULL,
  blanks = NULL,
  weights = NULL,
  model = "lm",
  check_assumptions = TRUE,
  ...
)

\method{print}{calibration}(x, ...)

\method{summary}{calibration}(object, ...)

\method{plot}{calibration}(x, interval = "conf", level = 0.95, ...)

\method{as.list}{calibration}(x, which = c("coef", "adj.r.squared", "lod", "loq", "blanks"), ...)

lod(x, ...)

\method{lod}{default}(x, ...)

\method{lod}{calibration}(x, blanks = NULL, alpha = 0.01, level = 0.05, ...)

loq(x, ...)

\method{loq}{default}(x, ...)

\method{loq}{calibration}(x, blanks = NULL, alpha = 0.01, k = 3, level = 0.05, maxiter = 10, ...)

\method{predict}{calibration}(object, newdata = NULL, interval = "conf", ...)

inv_predict(x, ...)

\method{inv_predict}{default}(x, ...)

\method{inv_predict}{calibration}(x, y, below_lod = NULL, method = "analytic", ...)
}
\arguments{
\item{formula}{model formula providing the recorded signal intensities with
respect to the nominal/specified analyte concentrations in the form of
\code{signal ~ concentration} or \code{signal ~ concentration - 1}; model
formulas are currently restricted to those forms.}

\item{data}{an optional data frame containing the variables in the model.}

\item{blanks}{a vector of numeric blank values overriding those automatically
retrieved from calibration data.}

\item{weights}{an optional character string containing one or more model
variables, for example, in the form of "\code{1/concentration^0.5}" or
"\code{1/signal}" which is internally converted to a numeric vector and
passed to the fitting process of the selected model; see also
\code{\link{weight_select}()}}

\item{model}{model class to be used for fitting; currently,
\code{\link[stats]{lm}()} and \code{\link[MASS]{rlm}()} are supported.}

\item{check_assumptions}{automatically check for normality and
homoscedasticity of model residuals using \code{\link[stats]{shapiro.test}()}
and \code{\link[lmtest]{bptest}()}, respectively; only executed if
\code{weights == NULL}.}

\item{\dots}{further arguments passed to submethods; for
instance, the respective model environment such as \code{\link[stats]{lm}()},
\code{\link[base]{print}()}, or \code{\link[graphics]{plot}()}.}

\item{x, object}{an object of class '\code{calibration}' with a model formula
as shown above.}

\item{interval}{type of interval plotted (can be abbreviated); see
\code{\link[stats]{predict}()} for details.}

\item{level}{tolerance/confidence level; see \code{\link[stats]{predict}()}
and \code{\link[stats]{confint}()} for details.}

\item{which}{character vector indicating the parameters to export; defaults 
to \code{c("coef", "adj.r.squared", "lod", "loq", "blanks")}.}

\item{alpha}{numeric; error tolerance for the detection limit (critical
value).}

\item{k}{numeric; relative uncertainty for the limit of quantification
(\code{1/beta}).}

\item{maxiter}{a positive integer specifying the maximum number of iterations
to calculate the LOQ.}

\item{newdata}{a data frame in which to look for variables with which to
predict. If \code{NULL}, values are guessed; \code{\link[stats]{predict.lm}()}
for details.}

\item{y}{numeric; the value to inverse predict.}

\item{below_lod}{value to be assigned if inverse prediction is below LOD;
defaults to \code{"NULL"} which keeps predicted values untouched. Other
options may be \code{NA} or \code{0}.}

\item{method}{character indicating the method used for inverse prediction;
defaults to \code{"analytic"}.}
}
\value{
\code{calibration} returns an object of \code{\link[base]{class}}
'\code{calibration}'.

\code{print()} calls the function parameters together with the respective LOD
and LOQ.
\code{summary()} may be used to retrieve the summary of the underlying model.
\code{plot()} plots the respective calibration curve together with the
measurement values.

\code{as.list()} returns a named list.

\code{lod()} and \code{loq()} return a named vector with the LOD and LOQ
together with lower and upper confidence limits.

\code{predict()} returns a \code{data.frame} of predictions.

\code{inv_predict()} predicts/calculates analyte concentrations from signal
intensities.
}
\description{
Defines a '\code{calibration}' object for the calculation of concentrations
from measurement signals including estimations for the limit of detection
(LOD) and limit of quantification (LOQ) in accordance with DIN 32645 (2008).
}
\details{
The LOD is defined as the lowest quantity of a substance that can be
distinguished from the absence of that substance (blank value) within a given
confidence level (\code{alpha}). The LOQ is defined as the lowest quantity of
a substance that can be quantified/distinguished from another sample given
with respect to a defined confidence level (\code{k}).

If the \code{data} supplied to \code{calibration} contain more than one blank
value, namely measurements with a nominal/specified concentration of or close
to zero, the LOD and LOQ are calculated from the deviation of the blank
samples. This method is called "blank method" according to DIN 32645 (2008)
and supposed to be more accurate than the so-called "calibration method"
which will be used for the estimation of LOD and LOQ when \code{data} does
not contain zero concentration measurements.
}
\examples{
data(din32645)
din <- calibration(Area ~ Conc, data = din32645)

print(din)
summary(din)
plot(din)

as.list(din)

lod(din)
loq(din)

predict(din)

inv_predict(din, 5000)

}
\references{
Almeida, A.M.D., Castel-Branco, M.M., & Falcao, A.C. (2002). Linear
regression for calibration lines revisited: weighting schemes for
bioanalytical methods. \emph{Journal of Chromatography B}, \bold{774}(2),
215-222. \doi{10.1016/S1570-0232(02)00244-1}.

Currie, L.A. (1999). Nomenclature in evaluation of analytical methods
including detection and quantification capabilities: (IUPAC Recommendations
1995). \emph{Analytica Chimica Acta} \bold{391}, 105-126.

DIN 32645 (2008). \emph{Chemical analysis - Decision limit, detection limit
and determination limit under repeatability conditions - Terms, methods,
evaluation}. Technical standard. Deutsches Institut für Normung, Berlin.

Massart, D.L., Vandeginste, B.G., Buydens, L.M.C., Lewi, P.J., &
Smeyers-Verbeke, J. (1997). \emph{Handbook of chemometrics and qualimetrics:
Part A}. Elsevier Science Inc.
}
\seealso{
\code{\link[investr]{invest}()} for alternative inverse prediction methods;

Other calibration: 
\code{\link{din32645}},
\code{\link{icp}},
\code{\link{matrix_effect}()},
\code{\link{neitzel2003}},
\code{\link{phenolics}},
\code{\link{weight_select}()}
}
\author{
Zacharias Steinmetz
}
\concept{calibration}
