% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{as_emphatic}
\alias{as_emphatic}
\title{Convert a data.frame, matrix or atomic vector into an emphatic version}
\usage{
as_emphatic(.data)
}
\arguments{
\item{.data}{data.frame, matrix or atomic vector}
}
\value{
An \code{emphatic} version of the given .data with added attributes for text and fill colours
}
\description{
This usually does not need to be called explicitly by the user.
}
\details{
The function adds the attributes necessary for keeping track of the
colours assigned to each cell.  This consists of 2 character matrices - one for
the text colour and one for the background colour.

Colour information is stored as R colour names (e.g. 'red') or 6 character
hex colours (e.g. '#ff0000').
}
\examples{
mtcars |>
  head() |>
  as_emphatic()
}
