% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFK.R
\name{MFK}
\alias{MFK}
\title{Calculate Composite Multifunctionality Index (MFK)}
\usage{
MFK(data, weights = NULL)
}
\arguments{
\item{data}{A data frame or matrix where rows represent observations and columns
represent ecosystem functions. Function values should be normalized to a
common scale (e.g., 0-1).}

\item{weights}{A numeric vector of weights for each function (column). If NULL,
equal weights are assigned to all functions. Default is NULL.}
}
\value{
A data frame containing:
\itemize{
  \item MFric: Multifunctionality richness values
  \item MFreg: Multifunctionality regularity values
  \item MFdiv: Multifunctionality divergence values
  \item MFK: Composite multifunctionality index values
}
}
\description{
Calculates a composite multifunctionality index based on the K index approach
(Wojcik 2024), integrating three facets of multifunctionality: richness (MFric),
regularity (MFreg), and divergence (MFdiv) using their geometric mean.
}
\details{
The composite index MFK is calculated as the geometric mean of three facets:
\deqn{MFK = \sqrt[3]{MFric \times MFreg \times MFdiv}}{MFK = (MFric * MFreg * MFdiv)^(1/3)}

This approach follows the K index methodology (Wojcik 2024), where the geometric
mean combines multiple facets of diversity into a single integrated measure.
The three facets represent:
\itemize{
  \item MFric: Multifunctionality richness
  \item MFreg: Multifunctionality regularity
  \item MFdiv: Multifunctionality divergence
}
}
\examples{
# Example with sample data
data <- data.frame(
  func1 = c(0.5, 0.3, 0.2),
  func2 = c(0.2, 0.4, 0.4),
  func3 = c(0.3, 0.3, 0.4)
)
rownames(data) <- c("Site1", "Site2", "Site3")

# Calculate MFK with equal weights
MFK(data)

# Calculate MFK with custom weights (emphasizing func2)
MFK(data, weights = c(1, 2, 1))


}
\references{
Wojcik, L. A., Gaedke, U., van Velzen, E., & Klauschies, T. (2025). Measuring overall functional
diversity by aggregating its multiple facets: Functional richness, biomass evenness, trait evenness
and dispersion. Methods in Ecology and Evolution, 16, 215–227.
}
\seealso{
\code{\link{MFric}}, \code{\link{MFreg}}, \code{\link{MFdiv}}
}
