% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_burden.R
\name{compare_energy_burden}
\alias{compare_energy_burden}
\title{Compare Energy Burden Between Years}
\usage{
compare_energy_burden(
  dataset = c("ami", "fpl"),
  states = NULL,
  group_by = "income_bracket",
  counties = NULL,
  vintage_1 = "2022",
  vintage_2 = "2018",
  format = TRUE,
  strict_matching = TRUE
)
}
\arguments{
\item{dataset}{Character, either "ami" or "fpl" for cohort data type}

\item{states}{Character vector of state abbreviations to filter by (optional)}

\item{group_by}{Character or character vector. Use keywords "income_bracket" (default),
"state", or "none" for standard groupings. Or provide custom column name(s)
for dynamic grouping (e.g., "geoid" for tract-level, c("state_abbr", "income_bracket")
for multi-level grouping). Custom columns must exist in the loaded data.}

\item{counties}{Character vector of county names or FIPS codes to filter by (optional).
Requires \code{states} to be specified.}

\item{vintage_1}{Character, first vintage year: "2018" or "2022" (default "2022")}

\item{vintage_2}{Character, second vintage year: "2018" or "2022" (default "2018")}

\item{format}{Logical, if TRUE returns formatted percentages (default TRUE)}

\item{strict_matching}{Logical, if TRUE (default) only compares income brackets
that exist in both vintages and warns about mismatched brackets. If FALSE,
compares all brackets (may result in NA values for brackets unique to one vintage).}
}
\value{
A data.frame with energy burden comparison showing:
\itemize{
\item neb_YYYY: Net Energy Burden for each vintage (where YYYY is the year)
\item change_pp: Absolute change in percentage points
\item change_pct: Relative percent change
}
}
\description{
Compare household energy burden metrics across different data vintages,
using proper Net Energy Return (Nh) aggregation methodology.
}
\examples{
\donttest{
# Single state comparison (fast, good for learning)
nc_comparison <- compare_energy_burden("ami", "NC", "income_bracket")

# Overall comparison (no grouping)
compare_energy_burden("ami", "NC", "none")
}

\donttest{
if (interactive()) {
  # Multi-state regional comparison (requires census data download)
  southeast <- compare_energy_burden(
    dataset = "fpl",
    states = c("NC", "SC", "GA", "FL"),
    group_by = "state"
  )

  # Nationwide comparison by income bracket (all 51 states)
  us_comparison <- compare_energy_burden(
    dataset = "ami",
    group_by = "income_bracket"
  )

  # Compare specific counties within a state (requires census data)
  compare_energy_burden("fpl", "NC", counties = c("Orange", "Durham", "Wake"))

  # Custom grouping by tract-level geoid (requires census data)
  compare_energy_burden("ami", "NC", group_by = "geoid")
}
}
}
