% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-openai-compatible.R
\name{chat_openai_compatible}
\alias{chat_openai_compatible}
\title{Chat with an OpenAI-compatible model}
\usage{
chat_openai_compatible(
  base_url,
  name = "OpenAI-compatible",
  system_prompt = NULL,
  api_key = NULL,
  credentials = NULL,
  model = NULL,
  params = NULL,
  api_args = list(),
  api_headers = character(),
  echo = c("none", "output", "all")
)
}
\arguments{
\item{base_url}{The base URL to the endpoint. This parameter is \strong{required}
since there is no default for OpenAI-compatible APIs.}

\item{name}{The name of the provider; this is shown in \code{\link[=token_usage]{token_usage()}} and
is used to compute costs.}

\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{api_key}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{credentials} instead.}

\item{credentials}{Credentials to use for authentication. If not provided,
will attempt to use the \code{OPENAI_API_KEY} environment variable.}

\item{model}{The model to use for chat. No default; depends on your provider.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{api_headers}{Named character vector of arbitrary extra headers appended
to every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
This function is for use with OpenAI-compatible APIs, also known as the
\strong{chat completions} API. If you want to use OpenAI itself, we recommend
\code{\link[=chat_openai]{chat_openai()}}, which uses the newer \strong{responses} API.

Many providers offer OpenAI-compatible APIs, including:
\itemize{
\item \href{https://ollama.com/}{Ollama} for local models
\item \href{https://docs.vllm.ai/}{vLLM} for self-hosted models
\item Various cloud providers with OpenAI-compatible endpoints
}
}
\examples{
\dontrun{
# Example with Ollama (requires Ollama running locally)
chat <- chat_openai_compatible(
  base_url = "http://localhost:11434/v1",
  model = "llama2"
)
chat$chat("What is the difference between a tibble and a data frame?")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
