% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-google-upload.R
\name{google_upload}
\alias{google_upload}
\title{Upload a file to gemini}
\usage{
google_upload(
  path,
  base_url = "https://generativelanguage.googleapis.com/",
  api_key = NULL,
  credentials = NULL,
  mime_type = NULL
)
}
\arguments{
\item{path}{Path to a file to upload.}

\item{base_url}{The base URL to the endpoint; the default is OpenAI's
public API.}

\item{api_key}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{credentials} instead.}

\item{credentials}{A function that returns a list of authentication headers
or \code{NULL}, the default, to use ambient credentials. See above for details.}

\item{mime_type}{Optionally, specify the mime type of the file.
If not specified, will be guesses from the file extension.}
}
\value{
A \verb{<ContentUploaded>} object that can be passed to \verb{$chat()}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function uploads a file then waits for Gemini to finish processing it
so that you can immediately use it in a prompt. It's experimental because
it's currently Gemini specific, and we expect other providers to evolve
similar feature in the future.

Uploaded files are automatically deleted after 2 days. Each file must be
less than 2 GB and you can upload a total of 20 GB. ellmer doesn't currently
provide a way to delete files early; please
\href{https://github.com/tidyverse/ellmer/issues}{file an issue} if this would
be useful for you.
}
\examples{
\dontrun{
file <- google_upload("path/to/file.pdf")

chat <- chat_google_gemini()
chat$chat(file, "Give me a three paragraph summary of this PDF")
}
}
