% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Schott.R
\name{Schott}
\alias{Schott}
\title{Schott's test for elliptical symmetry}
\usage{
Schott(X)
}
\arguments{
\item{X}{A numeric matrix.}
}
\value{
An object of class \code{"htest"} containing the following components:
\item{\code{statistic}}{The value of the test statistic.}
\item{\code{pvalue}}{The p-value of the test.}
\item{\code{alternative}}{A character string describing the alternative hypothesis.}
\item{\code{method}}{A character string indicating what type of test was performed.}
}
\description{
Test for elliptical symmetry.
}
\section{Background}{

A Wald-type test for elliptical symmetry based on fourth moments.
It compares the sample fourth moments with the expected theoretical ones under ellipticity.
Being based on fourth-order moments, the test is very simple to use but requires moments of order 8.
It has an asymptotic chi-squared distribution under the null hypothesis of ellipticity.
}

\examples{

## sepal width and length of the versicolor subset of the Iris data
X = datasets::iris[51:100,1:2]

Schott(X)

}
\references{
Schott, James R., (2002). Testing for elliptical symmetry in covariance-matrix-based analyses. \emph{Statistics & Probability Letters}, \bold{60}(4), 395-404.
}
