% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeat.R
\name{einops.repeat}
\alias{einops.repeat}
\alias{repeat}
\title{Allows reordering elements and repeating them in arbitrary combinations.}
\usage{
einops.repeat(x, expr, ..., .row_major = getOption("einops_row_major", FALSE))

`repeat`(x, expr, ..., .row_major = getOption("einops_row_major", FALSE))
}
\arguments{
\item{x}{tensor: array, matrix, or list of arrays of the same shape and type}

\item{expr}{string: reduction pattern}

\item{...}{either corresponding axes lengths or a single list of them.}

\item{.row_major}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} logical: whether to
use row-major order for the output
tensor. If \code{TRUE}, the \emph{operation} is performed in row-major order, but the
output will be in whatever order the parent framework uses (e.g. column-major
for \code{\link[base:array]{base::array()}}).}
}
\value{
tensor of the same type as input, with dimensions according to output
pattern
}
\description{
This operation includes functionality of repeat, tile, and broadcast
functions.
}
\details{
When composing axes, C-order enumeration is used (consecutive elements
have different last axis). Find more examples in the vignettes.
}
\section{Why can't the function be called as \verb{repeat()}?}{

\code{repeat} is a reserved keyword in R that acts the same as
\verb{while(TRUE)}, and has no way of being overridden. Hence,
this function can only be called as \code{einops.repeat()} or
using backticks as \code{`repeat`()}.
}

\examples{
if (requireNamespace("abind", quietly = TRUE)) {

set.seed(42)
# a grayscale image (of shape height x width)
image <- array(rnorm(30 * 40), dim = c(30, 40))

# change it to RGB format by repeating in each channel
output <- einops.repeat(image, 'h w -> h w c', c = 3)
# Visualize the output
as_image_tensor(output)

# repeat image 2 times along height (vertical axis)
output <- einops.repeat(image, 'h w -> (r h) w', r = 2)

# repeat image 2 times along height and 3 times along width
output <- einops.repeat(image, 'h w -> (h2 h) (w3 w)', h2 = 2, w3 = 3)

# convert each pixel to a small square 2x2, i.e. upsample an image by 2x
output <- einops.repeat(image, 'h w -> (h h2) (w w2)', h2 = 2, w2 = 2)

# 'pixelate' an image first by downsampling by 2x, then upsampling
downsampled <- reduce(image, '(h h2) (w w2) -> h w', 'mean', h2 = 2, w2 = 2)
output <- einops.repeat(downsampled, 'h w -> (h h2) (w w2)', h2 = 2, w2 = 2)
as_image_tensor(einops.repeat(output, 'h w -> h w 3'))

}

}
