% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-networks.r
\name{plotNetworkFromMatrix}
\alias{plotNetworkFromMatrix}
\title{Plot graphs from adjacency matrices}
\usage{
plotNetworkFromMatrix(
  adjacency,
  true.adjacency = NULL,
  labels = TRUE,
  exclude.orphans = TRUE,
  lwd = 1,
  edge.arrow.size = 0.8,
  severe.threshold = 0.5
)
}
\arguments{
\item{adjacency}{the square adjacency matrix.}

\item{true.adjacency}{optional. The reference "true" square adjacency matrix to which to compare the first one.}

\item{labels}{logical. Draw default labels?}

\item{exclude.orphans}{logical. Hide nodes without links?}

\item{lwd}{a numerical value giving the amount by which the arrows' line width should be magnified
relative to the default, when plotting the weighted graph (only used when
\code{true.adjacency} is not provided).}

\item{edge.arrow.size}{size of the arrow heads. See \code{igraph::plot.igraph}}

\item{severe.threshold}{the absolute threshold above which the interaction weights are highlighted in the graph.}
}
\value{
The corresponding igraph network, invisibly.
}
\description{
Plots a graph from a weighted adjacency matrix, using \code{igraph}'s plotting functions,
optionally comparing it with another "true" adjacency matrix.
}
\details{
When comparing two adjacency matrices
}
\note{
The arrow direction depicts the direction of the interaction. Species in columns affect species in rows.

The matrices should include row and column labels, otherwise the node labels may not correspond to the species index
(when \code{exclude.orphans = TRUE})
}
\examples{
# generate two adjacency matrices with 15 species and 10 interactions
A <- matrix(0, ncol=15, nrow=15)
A[sample(length(A), 10)] <- runif(10)

B <- matrix(0, ncol=15, nrow=15)
B[sample(length(B), 10)] <- runif(10)

# set the species names
rownames(A) <- rownames(B) <-
  colnames(A) <- colnames(B) <- paste0("S", 1:15)

plotNetworkFromMatrix(A, B)

}
