% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getValues.R
\name{getValues}
\alias{getValues}
\title{Retrieve all cues from a vector of text strings.}
\usage{
getValues(text, split = "_", unique = FALSE, decreasing = FALSE)
}
\arguments{
\item{text}{A vector with text strings containing cues or outcomes, 
separated by a symbol specified by \code{split}.}

\item{split}{separator between cues.}

\item{unique}{Logical: only return unique values (TRUE) or all values 
(FALSE, default). When unique values are bein returned, they are sorted.}

\item{decreasing}{Logical: sorting in alphabetical order (FALSE, default) or the reverse order (TRUE)? Only applies when \code{unique} is set to TRUE.}
}
\value{
A vector with strings
}
\description{
Retrieve all cues from a vector of text strings.
}
\examples{

# load example data:
data(dat)
# prepare training data:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
train <- createTrainingData(dat)

# find all cues in trainingdata:
cues <- getValues(train$Cues)
table(cues)
# find all outcomes in data:
out <- getValues(train$Outcomes)
table(out)
# find (sorted) unique cues and outcomes:
getValues(dat$Cues, unique=TRUE)
getValues(dat$Outcomes, unique=TRUE)

}
\seealso{
\code{\link{strsplit}}, \code{\link{sort}}, \code{\link{unique}}, 
\code{\link{getOutcomes}}, \code{\link{getCues}}
}
\author{
Jacolien van Rij
}
