% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto-edina.R
\name{auto_edina}
\alias{auto_edina}
\title{Auto EDINA model selection routine}
\usage{
auto_edina(data, k = 2:4, burnin = 10000, chain_length = 20000)
}
\arguments{
\item{data}{Binary responses to assessments in \code{matrix}
form with dimensions \eqn{N \times J}{N x J}.}

\item{k}{Number of Attribute Levels as a positive \code{integer}.}

\item{burnin}{Number of Observations to discard on the chain.}

\item{chain_length}{Length of the MCMC chain}
}
\value{
An \code{auto_edina} object that contains:
\itemize{
\item \code{edina_models}: A list containing all estimated \code{edina} model objects.
\item \code{criterions}: Information criterions calculated for each model
\item \code{k_checked}: Varying \code{k} dimensions checked.
\item \code{j}: Number of Items
}
}
\description{
Automatically select an appropriate \eqn{K} dimension for a \eqn{Q} matrix
under the Exploratory Deterministic Input, Noise And gate (EDINA) Model.
}
\examples{
if(requireNamespace("simcdm", quietly = TRUE)) {

# Set a seed for reproducibility
set.seed(1512)

# Setup data simulation parameters
N = 15   # Number of Examinees / Subjects
J = 10   # Number of Items
K = 2    # Number of Skills / Attributes

# Note:
# Sample size and attributes have been reduced to create a minimally
# viable example that can be run during CRAN's automatic check.
# Please make sure to have a larger sample size...

# Assign slipping and guessing values for each item
ss = gs = rep(.2, J)

# Simulate an identifiable Q matrix
Q = simcdm::sim_q_matrix(J, K)

# Simulate subject attributes
subject_alphas = simcdm::sim_subject_attributes(N, K)

# Simulate items under the DINA model
items_dina = simcdm::sim_dina_items(subject_alphas, Q, ss, gs)

\donttest{
# Requires at least 15 seconds of execution time.
# Three EDINA models will be fit with increasing number of attributes.
model_set_edina = auto_edina(items_dina, k = 2:4)

# Display results
model_set_edina

# Retrieve criterion table
table = summary(model_set_edina)

# Extract "best model"
best_model(model_set_edina)
}
}

}
\seealso{
\code{\link[=autoplot.auto_edina]{autoplot.auto_edina()}},
\code{\link[=best_model]{best_model()}},
\code{\link[=model_selection_graph]{model_selection_graph()}},
\code{\link[=parameter_evolution_graph]{parameter_evolution_graph()}}
}
