% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menu.R
\name{menu_bibd}
\alias{menu_bibd}
\title{Balance incomplete block design}
\usage{
menu_bibd(
  t = random_integer_small(min = 3),
  k = random_integer_small(max = t - 1),
  r = random_integer_small(),
  seed = random_seed_number()
)
}
\arguments{
\item{t}{The number of treatments.}

\item{k}{The size of the block. This should be less than the number of
treatments.}

\item{r}{The number of replications for each treatment level.}

\item{seed}{A scalar value for computational reproducibility.}
}
\value{
A recipe for balance incomplete block design.
}
\description{
Some combinations of parameter values cannot create a balanced incomplete
block design.
}
\examples{
menu_bibd(t = 3, k = 2, r = 4)
}
\seealso{
Other recipe-designs: 
\code{\link{menu_crd}()},
\code{\link{menu_factorial}()},
\code{\link{menu_graeco}()},
\code{\link{menu_hyper_graeco}()},
\code{\link{menu_lsd}()},
\code{\link{menu_rcbd}()},
\code{\link{menu_split}()},
\code{\link{menu_strip}()},
\code{\link{menu_youden}()}
}
\concept{recipe-designs}
