% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSelector.R
\name{makeSelector}
\alias{makeSelector}
\title{Construct a selection operator.}
\usage{
makeSelector(
  selector,
  supported = getAvailableRepresentations(),
  supported.objectives,
  supported.opt.direction = "minimize"
)
}
\arguments{
\item{selector}{[\code{function}]\cr
Actual selection operator.}

\item{supported}{[\code{character}]\cr
Vector of strings/names of supported parameter representations. Possible choices:
\dQuote{permutation}, \dQuote{float}, \dQuote{binary} or \dQuote{custom}.}

\item{supported.objectives}{[\code{character}]\cr
At least one of \dQuote{single-objective} or \dQuote{multi-objective}.}

\item{supported.opt.direction}{[\code{character(1-2)}]\cr
Does the selector work for maximization tasks xor minimization tasks or both?
Default is \dQuote{\code{minimize}}, which means that the selector selects
in favour of low fitness values.}
}
\value{
[\code{ecr_selector}]
  Selector object.
}
\description{
Helper function which defines a selector method, i. e., an operator which
takes the population and returns a part of it for mating or survival.
}
