% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gouldian_finch}
\alias{gouldian_finch}
\title{Gouldian Finch Occurrence Data (2014–2024)}
\format{
A tibble with 3,921 rows and 14 variables:
\describe{
  \item{obs_lat}{Latitude of the observation (decimal degrees)}
  \item{obs_lon}{Longitude of the observation (decimal degrees)}
  \item{date}{Date of the observation (YYYY-MM-DD)}
  \item{time}{Time of the observation (HH:MM:SS)}
  \item{year}{Year of the observation}
  \item{month}{Month (1–12)}
  \item{day}{Day of the month}
  \item{hour}{Hour extracted from the time (0–23)}
  \item{weekday}{Day of the week (as ordered factor)}
  \item{dayofyear}{Day of the year (1–366)}
  \item{sci_name}{Scientific name of the species}
  \item{record_type}{Type of observation (e.g., HUMAN_OBSERVATION)}
  \item{obs_state}{Australian state where the observation was recorded}
  \item{ws_id}{Nearest weather station ID (e.g., "948280-99999")}
}
}
\source{
Atlas of Living Australia via \pkg{galah}
}
\usage{
gouldian_finch
}
\description{
This dataset contains cleaned and processed occurrence records for the Gouldian Finch
(*Chloebia gouldiae*) in Australia between 2014 and 2024. It includes spatial coordinates,
temporal details, species information, and the ID of the nearest weather station for each observation.
}
\details{
The data was retrieved from the Atlas of Living Australia using the \pkg{galah} package,
then standardized, cleaned, and matched to the three closest weather stations using geospatial tools.
}
\examples{
data(gouldian_finch)
head(gouldian_finch)
}
\seealso{
\code{\link{glowworms}}, \code{\link{weather}}
}
\keyword{datasets}
