% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ed_get.R
\name{ed_get}
\alias{ed_get}
\title{Get a dataset from EconDataverse Hugging Face repositories}
\usage{
ed_get(dataset, table, columns = NULL, quiet = FALSE)
}
\arguments{
\item{dataset}{Character string naming the dataset repository
on Hugging Face (e.g., \code{"wbids"} for World Bank Indicators).}

\item{table}{Character string naming the table.}

\item{columns}{Character vector naming the columns. Defaults to \code{NULL}.}

\item{quiet}{Logical; suppress messages? Default: FALSE.}
}
\value{
A \code{data.frame} containing the requested dataset, or \code{NULL} if
the download fails.
}
\description{
Downloads and reads a Parquet file directly from the EconDataverse
Hugging Face datasets using the \code{arrow} package.
}
\examples{
\donttest{
df <- ed_get("wbids", "counterparts")
head(df)

df <- ed_get(
  "wbids",
  "counterparts",
  columns = c("counterpart_id", "counterpart_name"))
}

}
