% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trends.R
\name{vectorize_trends}
\alias{vectorize_trends}
\title{Convert Trends Data Products to points or circles}
\usage{
vectorize_trends(trends, output = c("circles", "points"), crs = 4326)
}
\arguments{
\item{trends}{data frame; trends data for a single species as returned by
\code{\link[=load_trends]{load_trends()}}.}

\item{output}{character; "points" outputs spatial points while "circles"
outputs circles with areas roughly proportional to the relative abundance
within that 27 km grid cell.}

\item{crs}{character or \code{sf} \link[sf:st_crs]{crs} object; coordinate reference
system to output the results in. For points, unprojected latitude-longitude
coordinates (the default) are most typical, while for circles use whatever
equal area CRS you intend to use when mapping the data otherwise the
"circles" will appear skewed.}
}
\value{
Vetorized trends data as an \link[sf:sf]{sf} object.
}
\description{
The eBird trends data are stored in a tabular format, where each row gives
the trend estimate for a single cell in a 27 km x 27 km equal area grid. For
many applications, an explicitly spatial format is more useful. This function
uses the cell center coordinates to convert the tabular trend estimates to
points or circles in \link[sf:sf]{sf} format. Trends can be converted to points
or to circles with areas roughly proportional to the relative abundance
within that 27 km grid cell. These abundance-scaled circles are what is used
to produce the trends maps on the eBird Status and Trends website.
}
\examples{
\dontrun{
# download example trends data if it hasn't already been downloaded
ebirdst_download_trends("yebsap-example")

# load trends
trends <- load_trends("yebsap-example")

# vectorize as points
vectorize_trends(trends, "points")
# vectorize as circles
vectorize_trends(trends, "circles", crs = "+proj=eqearth")
}
}
